﻿using System;
using System.Diagnostics;
using System.Linq;

namespace TargetUtility
{
    class TargetManager
    {
        private const string processName = "NintendoTargetManager";

        public static void Boot(
            bool minimized = false,
            bool tasktray = false,
            bool disableLogging = false,
            bool ForInitialize = false)
        {
            using (var process = new Process())
            {
                process.StartInfo.FileName = EnvironmentInfo.TargetManager;
                process.StartInfo.Arguments =
                    (minimized ? "-minimized " : "") +
                    (tasktray ? "-tasktray " : "") +
                    (disableLogging ? "-disablelogging " : "") +
                    (ForInitialize ? "-ForInitialize " : "");
                process.StartInfo.UseShellExecute = false;
                process.Start();
            }
        }

        public static void Shutdown()
        {
            TimeSpan timeout = TimeSpan.FromSeconds(5);

            var process = Process.GetProcessesByName(processName).FirstOrDefault();
            if (process != null)
            {
                process.CloseMainWindow();
                if (!process.WaitForExit((int)timeout.TotalMilliseconds))
                {
                    process.Kill();
                }
            }
        }

        public static void Kill()
        {
            Process.GetProcessesByName(processName).FirstOrDefault()?.Kill();
        }

        public static void Reboot(
            bool minimized = false,
            bool tasktray = false,
            bool disableLogging = false,
            bool ForInitialize = false)
        {
            Shutdown();
            Boot(minimized, tasktray, disableLogging, ForInitialize);
        }
    }
}
