﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnc/nn_Log.h>
#include <nnc/nn_SdkLog.h>

// テストの期待値（共通）
const char* ExpectFileName = __FILE__;

// ----------------------------------------------------------------------------
// NNC_LOG() 用
// ----------------------------------------------------------------------------

void CallNncLog(void)
{
    NNC_LOG("TEST string: %s integer: %d by NN_LOG\n", "hello", 1234);
}

// テストの期待値
const int ExpectLineNumber = __LINE__ - 4; // ソースコード上の固定値
const char* ExpectMessage = "TEST string: hello integer: 1234 by NN_LOG\n";

// ----------------------------------------------------------------------------
// NNC_VLOG() 用
// ----------------------------------------------------------------------------

static void CallNncVlogImpl(const char* format, ...)
{
    va_list args;
    va_start(args, format);
    NNC_VLOG(format, args);
    va_end(args);
}

void CallNncVlog(void)
{
    CallNncVlogImpl("TEST string: %s integer: %d by NNC_VLOG\n", "hello", 1234);
}

// テストの期待値
const int ExpectLineNumberByVlog = __LINE__ - 10; // ソースコード上の固定値
const char* ExpectMessageByVlog = "TEST string: hello integer: 1234 by NNC_VLOG\n";

// ----------------------------------------------------------------------------
// NNC_SDK_LOG() 用
// ----------------------------------------------------------------------------
void CallNncSdkLog(void)
{
    NNC_SDK_LOG("TEST string: %s integer: %d by NNC_SDK_LOG\n", "hello", 1234);
}

// テストの期待値
const int ExpectLineNumberBySdkLog = __LINE__ - 4; // ソースコード上の固定値
const char* ExpectMessageBySdkLog = "TEST string: hello integer: 1234 by NNC_SDK_LOG\n";

// ----------------------------------------------------------------------------
// NNC_SDK_VLOG() 用
// ----------------------------------------------------------------------------
static void CallNncSdkVlogImpl(const char* format, ...)
{
    va_list args;
    va_start(args, format);
    NNC_SDK_VLOG(format, args);
    va_end(args);
}

void CallNncSdkVlog(void)
{
    CallNncSdkVlogImpl("TEST string: %s integer: %d by NNC_SDK_VLOG\n", "hello", 1234);
}

// テストの期待値
const int ExpectLineNumberBySdkVlog = __LINE__ - 10; // ソースコード上の固定値
const char* ExpectMessageBySdkVlog = "TEST string: hello integer: 1234 by NNC_SDK_VLOG\n";
