﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/diag/detail/diag_DetailTranslation.h>

#include "testDiag_Translation.dictionary.h"

// 文字コード変換のキャッシュがメモリリークの検出対象にならないことを確かめるテスト
// DEBUG ビルド以外ではメモリリーク検出を行わないため、常にテストが成功する点に注意

// ビルド条件によって発生する警告を無効化
#pragma warning(push)
#pragma warning(disable : 4101)
#pragma warning(disable : 4127)

TEST(TranslationTest, AvoidMemoryLeakDetection)
{
    _CrtMemState initialMemoryState;
    _CrtMemState finalMemoryState;
    _CrtMemState memoryStateDifference;

    _CrtMemCheckpoint(&initialMemoryState);

    // 文字コード変換のキャッシュを確実に作るために、NN_SDK_TEXT_VALID を読んで結果を出力
    NN_LOG(NN_SDK_TEXT_TESTDIAG("こんにちは\n"));

    _CrtMemCheckpoint(&finalMemoryState);

    // メモリリークを検出したら、結果を表示してテストを失敗させる
    if (_CrtMemDifference(&memoryStateDifference, &initialMemoryState, &finalMemoryState))
    {
        size_t memoryLeakBytes = 0;
        memoryLeakBytes += memoryStateDifference.lSizes[_NORMAL_BLOCK];
        ASSERT_EQ(0, memoryLeakBytes);
    }
}

#pragma warning(pop)
