﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include "../../../../../Programs/Chris/Sources/Libraries/diag/detail/diag_ObserverManager.h"

namespace {

int g_ObserverResults[4];

typedef void (*ObserverType)(int context);
struct ObserverHolderType
{
    ObserverType observer;
    ObserverHolderType* next;
    bool isRegistered;
};

void Observer0(int context)
{
    g_ObserverResults[0] = context;
}
void Observer1(int context)
{
    g_ObserverResults[1] = context;
}
void Observer2(int context)
{
    g_ObserverResults[2] = context;
}
void Observer3(int context)
{
    g_ObserverResults[3] = context;
}

void ClearResults()
{
    for(int index = 0; index < 4; ++index)
    {
        g_ObserverResults[index] = 0;
    }
}

void InitializeObserverHolder(ObserverHolderType* observerHolder, ObserverType observer)
{
    observerHolder->observer = observer;
    observerHolder->next = nullptr;
    observerHolder->isRegistered = false;
}

// ０と１は static な場所にホルダを置く
ObserverHolderType g_ObserverHolder0;
ObserverHolderType g_ObserverHolder1;

} // anonymous

TEST(ObserverManagerTest, RegisterObserver)
{
    // ２と３はスタックにホルダを置く
    ObserverHolderType observerHolder2;
    ObserverHolderType observerHolder3;

    InitializeObserverHolder(&g_ObserverHolder0, Observer0);
    InitializeObserverHolder(&g_ObserverHolder1, Observer1);
    InitializeObserverHolder(&observerHolder2, Observer2);
    InitializeObserverHolder(&observerHolder3, Observer3);

    nn::diag::detail::ObserverManager<ObserverHolderType, int> observerManager;

    int context = 0;

    // すべて追加する
    observerManager.RegisterObserver(&g_ObserverHolder0);
    observerManager.RegisterObserver(&g_ObserverHolder1);
    observerManager.RegisterObserver(&observerHolder2);
    observerManager.RegisterObserver(&observerHolder3);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(context, g_ObserverResults[0]);
    EXPECT_EQ(context, g_ObserverResults[1]);
    EXPECT_EQ(context, g_ObserverResults[2]);
    EXPECT_EQ(context, g_ObserverResults[3]);

    // 途中のコールバックを取り外す
    observerManager.UnregisterObserver(&g_ObserverHolder1);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(context, g_ObserverResults[0]);
    EXPECT_EQ(0      , g_ObserverResults[1]);
    EXPECT_EQ(context, g_ObserverResults[2]);
    EXPECT_EQ(context, g_ObserverResults[3]);

    // 末尾のコールバックを取り外す
    observerManager.UnregisterObserver(&observerHolder3);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(context, g_ObserverResults[0]);
    EXPECT_EQ(0      , g_ObserverResults[1]);
    EXPECT_EQ(context, g_ObserverResults[2]);
    EXPECT_EQ(0      , g_ObserverResults[3]);

    // 先頭のコールバックを取り外す
    observerManager.UnregisterObserver(&g_ObserverHolder0);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(0      , g_ObserverResults[0]);
    EXPECT_EQ(0      , g_ObserverResults[1]);
    EXPECT_EQ(context, g_ObserverResults[2]);
    EXPECT_EQ(0      , g_ObserverResults[3]);

    // 唯一のコールバックを取り外す
    observerManager.UnregisterObserver(&observerHolder2);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(0      , g_ObserverResults[0]);
    EXPECT_EQ(0      , g_ObserverResults[1]);
    EXPECT_EQ(0      , g_ObserverResults[2]);
    EXPECT_EQ(0      , g_ObserverResults[3]);

    // 再度すべて追加する
    observerManager.RegisterObserver(&g_ObserverHolder0);
    observerManager.RegisterObserver(&g_ObserverHolder1);
    observerManager.RegisterObserver(&observerHolder2);
    observerManager.RegisterObserver(&observerHolder3);

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(context, g_ObserverResults[0]);
    EXPECT_EQ(context, g_ObserverResults[1]);
    EXPECT_EQ(context, g_ObserverResults[2]);
    EXPECT_EQ(context, g_ObserverResults[3]);

    // すべて削除する
    observerManager.UnregisterAllObserver();

    ClearResults();
    context++;
    observerManager.InvokeAllObserver(context);

    EXPECT_EQ(0      , g_ObserverResults[0]);
    EXPECT_EQ(0      , g_ObserverResults[1]);
    EXPECT_EQ(0      , g_ObserverResults[2]);
    EXPECT_EQ(0      , g_ObserverResults[3]);
}
