﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#define NN_DETAIL_ENABLE_SDK_LOG
#include <nn/nn_SdkLog.h>

#define NN_DETAIL_ENABLE_SDK_STRUCTURED_LOG
#include "test_module_x_log.h"
#include "test_module_y_log.h"

TEST(LogFilterTest, Basic)
{
    NN_LOG("Log from nn_log.\n");

    NN_SDK_LOG("Log from nn_sdk_log.\n");

    NN_LOG("Log at line:%d.\n", __LINE__); // 行を変更するとテストが失敗するので注意。

    NN_LOG("Log at %s.\n", nn::os::GetThreadNamePointer(nn::os::GetCurrentThread()));

    NN_DETAIL_TEST_MODULE_X_TRACE("Log from module_x_trace_v0.\n");
    NN_DETAIL_TEST_MODULE_X_TRACE_V1("Log from module_x_trace_v1.\n");
    NN_DETAIL_TEST_MODULE_X_TRACE_V2("Log from module_x_trace_v2.\n");
    NN_DETAIL_TEST_MODULE_X_TRACE_V3("Log from module_x_trace_v3.\n");

    NN_DETAIL_TEST_MODULE_X_INFO("Log from module_x_info_v0.\n");
    NN_DETAIL_TEST_MODULE_X_INFO_V1("Log from module_x_info_v1.\n");
    NN_DETAIL_TEST_MODULE_X_INFO_V2("Log from module_x_info_v2.\n");
    NN_DETAIL_TEST_MODULE_X_INFO_V3("Log from module_x_info_v3.\n");

    NN_DETAIL_TEST_MODULE_X_WARN("Log from module_x_warn_v0.\n");
    NN_DETAIL_TEST_MODULE_X_WARN_V1("Log from module_x_warn_v1.\n");
    NN_DETAIL_TEST_MODULE_X_WARN_V2("Log from module_x_warn_v2.\n");
    NN_DETAIL_TEST_MODULE_X_WARN_V3("Log from module_x_warn_v3.\n");

    NN_DETAIL_TEST_MODULE_X_ERROR("Log from module_x_error_v0.\n");
    NN_DETAIL_TEST_MODULE_X_ERROR_V1("Log from module_x_error_v1.\n");
    NN_DETAIL_TEST_MODULE_X_ERROR_V2("Log from module_x_error_v2.\n");
    NN_DETAIL_TEST_MODULE_X_ERROR_V3("Log from module_x_error_v3.\n");

    NN_DETAIL_TEST_MODULE_X_FATAL("Log from module_x_fatal_v0.\n");
    NN_DETAIL_TEST_MODULE_X_FATAL_V1("Log from module_x_fatal_v1.\n");
    NN_DETAIL_TEST_MODULE_X_FATAL_V2("Log from module_x_fatal_v2.\n");
    NN_DETAIL_TEST_MODULE_X_FATAL_V3("Log from module_x_fatal_v3.\n");

    NN_DETAIL_TEST_MODULE_Y_TRACE("Log from module_y_trace_v0.\n");
    NN_DETAIL_TEST_MODULE_Y_TRACE_V1("Log from module_y_trace_v1.\n");
    NN_DETAIL_TEST_MODULE_Y_TRACE_V2("Log from module_y_trace_v2.\n");
    NN_DETAIL_TEST_MODULE_Y_TRACE_V3("Log from module_y_trace_v3.\n");

    NN_DETAIL_TEST_MODULE_Y_INFO("Log from module_y_info_v0.\n");
    NN_DETAIL_TEST_MODULE_Y_INFO_V1("Log from module_y_info_v1.\n");
    NN_DETAIL_TEST_MODULE_Y_INFO_V2("Log from module_y_info_v2.\n");
    NN_DETAIL_TEST_MODULE_Y_INFO_V3("Log from module_y_info_v3.\n");

    NN_DETAIL_TEST_MODULE_Y_WARN("Log from module_y_warn_v0.\n");
    NN_DETAIL_TEST_MODULE_Y_WARN_V1("Log from module_y_warn_v1.\n");
    NN_DETAIL_TEST_MODULE_Y_WARN_V2("Log from module_y_warn_v2.\n");
    NN_DETAIL_TEST_MODULE_Y_WARN_V3("Log from module_y_warn_v3.\n");

    NN_DETAIL_TEST_MODULE_Y_ERROR("Log from module_y_error_v0.\n");
    NN_DETAIL_TEST_MODULE_Y_ERROR_V1("Log from module_y_error_v1.\n");
    NN_DETAIL_TEST_MODULE_Y_ERROR_V2("Log from module_y_error_v2.\n");
    NN_DETAIL_TEST_MODULE_Y_ERROR_V3("Log from module_y_error_v3.\n");

    NN_DETAIL_TEST_MODULE_Y_FATAL("Log from module_y_fatal_v0.\n");
    NN_DETAIL_TEST_MODULE_Y_FATAL_V1("Log from module_y_fatal_v1.\n");
    NN_DETAIL_TEST_MODULE_Y_FATAL_V2("Log from module_y_fatal_v2.\n");
    NN_DETAIL_TEST_MODULE_Y_FATAL_V3("Log from module_y_fatal_v3.\n");
}
