﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Log.h>
#include <nn/os.h>

namespace
{
    char g_FileNameInUtf8[] = {
        '\xE7', '\xB4', '\xA0', '\xE6', '\x95', '\xB5', '\xE3', '\x81',
        '\xAA', '\xE3', '\x83', '\x95', '\xE3', '\x82', '\xA1', '\xE3',
        '\x82', '\xA4', '\xE3', '\x83', '\xAB', '\xE5', '\x90', '\x8D',
        '\0'
    }; // 素敵なファイル名

    char g_FunctionNameInUtf8[] = {
        '\xE5', '\x81', '\x89', '\xE5', '\xA4', '\xA7', '\xE3', '\x81',
        '\xAA', '\xE9', '\x96', '\xA2', '\xE6', '\x95', '\xB0', '\xE5',
        '\x90', '\x8D', '\0'
    }; // 偉大な関数名

    char g_ModuleNameInUtf8[] = {
        '\xE4', '\xBC', '\x9D', '\xE8', '\xAA', '\xAC', '\xE7', '\x9A',
        '\x84', '\xE3', '\x83', '\xA2', '\xE3', '\x82', '\xB8', '\xE3',
        '\x83', '\xA5', '\xE3', '\x83', '\xBC', '\xE3', '\x83', '\xAB',
        '\xE5', '\x90', '\x8D', '\0'
    }; // 伝説的モジュール名

    char g_ThreadNameInUtf8[] = {
        '\xE7', '\xA9', '\xBA', '\xE8', '\x85', '\xB9', '\xE3', '\x82',
        '\x92', '\xE7', '\xB4', '\x9B', '\xE3', '\x82', '\x89', '\xE3',
        '\x82', '\x8F', '\xE3', '\x81', '\x9B', '\xE3', '\x82', '\x8B',
        '\xE3', '\x82', '\xB9', '\xE3', '\x83', '\xAC', '\xE3', '\x83',
        '\x83', '\xE3', '\x83', '\x89', '\xE5', '\x90', '\x8D', '\0'
    }; // 空腹を紛らわせるスレッド名
}

// テストを実行して、Log Viewer でメタ情報を表示して目視確認します。
// NG のメタ情報では、文字列が "(Invalid UTF8 string)" に置き換えられます。
TEST(LogTest, SanitizeInvalidUtf8)
{
    nn::diag::LogMetaData logMetaData;
    logMetaData.sourceInfo.lineNumber = __LINE__;
    logMetaData.sourceInfo.fileName = g_FileNameInUtf8;
    logMetaData.sourceInfo.functionName = g_FunctionNameInUtf8;
    logMetaData.moduleName = g_ModuleNameInUtf8;
    logMetaData.severity = ::nn::diag::LogSeverity_Info;
    logMetaData.verbosity = 0;
    logMetaData.useDefaultLocaleCharset = false;
    logMetaData.pAdditionalData = static_cast<void*>(0);
    logMetaData.additionalDataBytes = 0;
    nn::os::SetThreadNamePointer(nn::os::GetCurrentThread(), g_ThreadNameInUtf8);

    nn::diag::detail::LogImpl(logMetaData,
        "FileName:      OK\n"
        "FunctionName:  OK\n"
        "ModuleName:    OK\n"
        "Threadname:    OK\n\n");

    g_FileNameInUtf8[0] = 'A';

    nn::diag::detail::LogImpl(logMetaData,
        "FileName:      NG\n"
        "FunctionName:  OK\n"
        "ModuleName:    OK\n"
        "Threadname:    OK\n\n");

    g_FunctionNameInUtf8[0] = 'A';

    nn::diag::detail::LogImpl(logMetaData,
        "FileName:      NG\n"
        "FunctionName:  NG\n"
        "ModuleName:    OK\n"
        "Threadname:    OK\n\n");

    g_ModuleNameInUtf8[0] = 'A';

    nn::diag::detail::LogImpl(logMetaData,
        "FileName:      NG\n"
        "FunctionName:  NG\n"
        "ModuleName:    NG\n"
        "Threadname:    OK\n\n");

    g_ThreadNameInUtf8[0] = 'A';

    nn::diag::detail::LogImpl(logMetaData,
        "FileName:      NG\n"
        "FunctionName:  NG\n"
        "ModuleName:    NG\n"
        "Threadname:    NG\n\n");
}
