﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

// Result に対する ASSERT_TRUE 的なもの
#define NNT_DT_ASSERT_RESULT_SUCCESS(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { NN_LOG("%s(%d): Result(module:%d / description:%d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); ASSERT_TRUE(_r.IsSuccess());} } while (NN_STATIC_CONDITION(false))

#define NNT_DT_ASSERT_RESULT_INCLUDED(exp, result) \
    do { nn::Result _r = (result); if (!(_r <= exp)) { NN_LOG("%s(%d): Result(module:%d / description:%d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); ASSERT_TRUE(_r <= exp);} } while (NN_STATIC_CONDITION(false))
