﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/dt.h>
#include <nn/dt/detail/dt_InternalTypes.h>

#include <nnt/nntest.h>

#include "testDt_Common.h"

namespace nnt { namespace dt {

TEST(InterruptApi, Basic)
{
    nn::Result result;
    nn::dt::Node node;

    int count;
    nn::dt::InterruptInfo info[3];

    result = nn::dt::FindNodeByPath(&node, "/bus/uart");
    NNT_DT_ASSERT_RESULT_SUCCESS(result);

    result = nn::dt::GetInterruptCount(&count, &node);
    NNT_DT_ASSERT_RESULT_INCLUDED(nn::dt::ResultApiNotSupported(), result);

    result = nn::dt::GetInterrupt(info, &node);
    NNT_DT_ASSERT_RESULT_INCLUDED(nn::dt::ResultApiNotSupported(), result);

    result = nn::dt::GetInterruptArray(info, sizeof(info) / sizeof(info[0]), &node);
    NNT_DT_ASSERT_RESULT_INCLUDED(nn::dt::ResultApiNotSupported(), result);

    result = nn::dt::GetInterruptList(info, &count, sizeof(info) / sizeof(info[0]), &node);
    NNT_DT_ASSERT_RESULT_INCLUDED(nn::dt::ResultApiNotSupported(), result);
}

}}
