﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnc/nn_DeviceCode.h>
#include <nnc/nn_Log.h>
#include <nn/devicecode/devicecode_Builder.h>

#define NNT_MY_ASSERT_EQ(val1, val2) \
    do \
    { \
        if ((val1) != (val2)) \
        { \
            NNC_LOG("%s(%d): (%s) did not match (%s)\n", __FILE__, __LINE__, #val1, #val2); \
            return false; \
        } \
    } while( NNC_STATIC_CONDITION(0) )

#define NNT_MY_ASSERT_TRUE(condition) \
    do \
    { \
        if (!(condition)) \
        { \
            NNC_LOG("%s(%d): Assetion (%s) was not true\n", __FILE__, __LINE__, #condition); \
            return false; \
        } \
    } while( NNC_STATIC_CONDITION(0) )

#define NNT_MY_ASSERT_FALSE(condition) \
    do \
    { \
        if (condition) \
        { \
            NNC_LOG("%s(%d): Assetion (%s) was not false\n", __FILE__, __LINE__, #condition); \
            return false; \
        } \
    } while( NNC_STATIC_CONDITION(0) )

// TEST_P(InnerFormat, Basic) 相当
bool nntDeviceCodeInnerFormatTest(void)
{
    typedef struct InnerFormatTestParam
    {
        nndetailDeviceCodeType value;
        nnDeviceCodeCategory category;
        nnDeviceCodeInnerId innerId;
    } InnerFormatTestParam;

    const InnerFormatTestParam paramList[] =
    {
        { NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(0x00000000ul, 0x00000000ul), 0x00000000ul, 0x00000000ul },
        { NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(0x00000000ul, 0x0000fffful), 0x00000000ul, 0x0000fffful },
        { NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(0x000000fful, 0x00000000ul), 0x000000fful, 0x00000000ul },
        { NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(0x000000fful, 0x0000fffful), 0x000000fful, 0x0000fffful },

        // 範囲外の値がマスクされることの保証
        { NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(0xfffffffful, 0xfffffffful), 0x000000fful, 0x0000fffful },
    };

    NNC_LOG("%s: Begin\n", __FUNCTION__);

    for ( int i = 0; i < sizeof(paramList) / sizeof(paramList[0]); ++i )
    {
        InnerFormatTestParam param = paramList[i];
        nnDeviceCode dc = nnDeviceCodeMakeCode(param.value);

        NNT_MY_ASSERT_EQ(dc._value, param.value);
        NNT_MY_ASSERT_EQ(nnDeviceCodeGetCategory(dc), param.category);
        NNT_MY_ASSERT_TRUE(nnDeviceCodeIsCategory(dc, param.category));
        NNT_MY_ASSERT_EQ(nnDeviceCodeGetInnerId(dc), param.innerId);
        NNT_MY_ASSERT_EQ(
            dc._value,
            NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(nnDeviceCodeGetCategory(dc), nnDeviceCodeGetInnerId(dc))
        );
        NNT_MY_ASSERT_TRUE(
            nnDeviceCodeIsEqual(
                dc,
                nnDeviceCodeMakeCode(
                    NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL_NO_RANGECHECK(nnDeviceCodeGetCategory(dc), nnDeviceCodeGetInnerId(dc))
                )
            )
        );
    }

    // Invalid Code の内部表現の保証
    nnDeviceCode invalidDc = nnDeviceCodeMakeInvalidCode();
    NNT_MY_ASSERT_EQ(nnDeviceCodeGetCategory(invalidDc), NN_DEVICECODE_CATEGORY_INVALID);
    NNT_MY_ASSERT_EQ(nnDeviceCodeGetInnerId(invalidDc), 0ul);

    NNC_LOG("%s: Success\n", __FUNCTION__);
    return true;
}

// TEST(Death, OutOfRange) 用
nnDeviceCode nntDeviceCodeMakeDeviceCodeValue(nnDeviceCodeCategory category, nnDeviceCodeInnerId innerId)
{
    return NN_DETAIL_DEVICECODE_MAKE_CODE_IMPL(category, innerId);
}
