﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace dd {

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    // Windows 環境の場合、暫定で 4 コア扱いとする
    const int MaxCoreNum = 4;
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)

#if defined(NN_BUILD_CONFIG_HARDWARE_V2PCA15A7) && defined(NN_BUILD_CONFIG_CPU_CORTEX_A7)
    const int MaxCoreNum = 3;
#elif defined(NN_BUILD_CONFIG_HARDWARE_V2PCA15A7) && defined(NN_BUILD_CONFIG_CPU_CORTEX_A15)
    const int MaxCoreNum = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_KZMA9)
    const int MaxCoreNum = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_PANDA5)
    const int MaxCoreNum = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_AP9540)
    const int MaxCoreNum = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6)
    const int MaxCoreNum = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SECOMITX)
    const int MaxCoreNum = 1;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1)
    const int MaxCoreNum = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_SMMA53)
    const int MaxCoreNum = 2;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JUNO)
    #if defined NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH64
        const int MaxCoreNum = 2;
    #elif defined NN_BUILD_CONFIG_CPU_CORTEX_A53_AARCH64
        const int MaxCoreNum = 4;
    #endif
#elif defined(NN_BUILD_CONFIG_HARDWARE_MTBVP)
    const int MaxCoreNum = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
    const int MaxCoreNum = 4;
#elif defined(NN_BUILD_CONFIG_HARDWARE_NX)
    const int MaxCoreNum = 4;
#else
    // 定義のないボードの場合は 1 コアと想定する
    const int MaxCoreNum = 1;
#endif

#else
    #error "未サポートの OS 種別が指定されています。"
#endif

}} // namespace nnt::dd
