﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/crypto/crypto_Config.h>

#include "testCrypto_AesCipherTypes.h"
#include "testCrypto_HashTypes.h"
#include "testCrypto_MacTypes.h"

/*
  パフォーマンスターゲット記述用ソース
  特定の時点で計測した値を記載してチェックに利用できるようにする

  パフォーマンスの値は MB/s * 100 表記（60237 -> 602.37 MB/s）
 */

// NXFP2-a64
#if defined(NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH64)

const uint64_t AesEncryption::TargetPerformanceInPlace    = 59759;
const uint64_t AesEncryption::TargetPerformance           = 58704;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 59757;
const uint64_t AesDecryption::TargetPerformance           = 58710;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 45029;
const uint64_t AesCbcEncryption::TargetPerformance        = 45039;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 117493;
const uint64_t AesCbcDecryption::TargetPerformance        = 117585;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 114729;
const uint64_t AesCtrEncryption::TargetPerformance        = 114754;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 114754;
const uint64_t AesCtrDecryption::TargetPerformance        = 114787;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 108834;
const uint64_t AesXtsEncryption::TargetPerformance        = 108918;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 108863;
const uint64_t AesXtsDecryption::TargetPerformance        = 108915;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 42673;
const uint64_t AesGcmEncryption::TargetPerformance        = 42687;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 48803;
const uint64_t AesGcmDecryption::TargetPerformance        = 48787;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 18672;
const uint64_t AesCcmEncryption::TargetPerformance        = 18673;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 18673;
const uint64_t AesCcmDecryption::TargetPerformance        = 18673;

const uint64_t Sha1Generator::TargetPerformance           = 41325;
const uint64_t Sha256Generator::TargetPerformance         = 48678;

const uint64_t AesCmacGenerator::TargetPerformance        = 22287;
const uint64_t AesGmacGenerator::TargetPerformance        = 79022;


// NXFP2-a32
#elif defined(NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH32)

/*
Note: there are regressions from 2.0.0 NUP due to SIGLO-78297

const uint64_t AesEncryption::TargetPerformanceInPlace    = 35406;
const uint64_t AesEncryption::TargetPerformance           = 35408;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 37871;
const uint64_t AesDecryption::TargetPerformance           = 37876;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 45281;
const uint64_t AesCbcEncryption::TargetPerformance        = 45284;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 71799;
const uint64_t AesCbcDecryption::TargetPerformance        = 71804;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 55546;
const uint64_t AesCtrEncryption::TargetPerformance        = 55324;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 55546;
const uint64_t AesCtrDecryption::TargetPerformance        = 55324;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 48875;
const uint64_t AesXtsEncryption::TargetPerformance        = 48702;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 45246;
const uint64_t AesXtsDecryption::TargetPerformance        = 44959;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 2349;
const uint64_t AesGcmEncryption::TargetPerformance        = 2348;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 2339;
const uint64_t AesGcmDecryption::TargetPerformance        = 2331;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 12704;
const uint64_t AesCcmEncryption::TargetPerformance        = 12687;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 12703;
const uint64_t AesCcmDecryption::TargetPerformance        = 12689;

const uint64_t Sha1Generator::TargetPerformance           = 26403;
const uint64_t Sha256Generator::TargetPerformance         = 33691;

const uint64_t AesCmacGenerator::TargetPerformance        = 16976;
const uint64_t AesGmacGenerator::TargetPerformance        = 3917;
 */

const uint64_t AesEncryption::TargetPerformanceInPlace    = 33139;
const uint64_t AesEncryption::TargetPerformance           = 33149;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 35281;
const uint64_t AesDecryption::TargetPerformance           = 35290;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 45032;
const uint64_t AesCbcEncryption::TargetPerformance        = 45040;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 67270;
const uint64_t AesCbcDecryption::TargetPerformance        = 67282;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 55120;
const uint64_t AesCtrEncryption::TargetPerformance        = 54748;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 55124;
const uint64_t AesCtrDecryption::TargetPerformance        = 54748;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 47783;
const uint64_t AesXtsEncryption::TargetPerformance        = 47474;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 42890;
const uint64_t AesXtsDecryption::TargetPerformance        = 42470;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 2401;
const uint64_t AesGcmEncryption::TargetPerformance        = 2384;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 2405;
const uint64_t AesGcmDecryption::TargetPerformance        = 2388;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 12576;
const uint64_t AesCcmEncryption::TargetPerformance        = 12553;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 12576;
const uint64_t AesCcmDecryption::TargetPerformance        = 12554;

const uint64_t Sha1Generator::TargetPerformance           = 27542;
const uint64_t Sha256Generator::TargetPerformance         = 31972;

const uint64_t AesCmacGenerator::TargetPerformance        = 15975;
const uint64_t AesGmacGenerator::TargetPerformance        = 3927;


// Win64_VS2017
#elif defined(NN_BUILD_CONFIG_CPU_X64)

const uint64_t AesEncryption::TargetPerformanceInPlace    = 375896;
const uint64_t AesEncryption::TargetPerformance           = 365966;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 341519;
const uint64_t AesDecryption::TargetPerformance           = 342053;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 112732;
const uint64_t AesCbcEncryption::TargetPerformance        = 112719;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 276546;
const uint64_t AesCbcDecryption::TargetPerformance        = 283393;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 565072;
const uint64_t AesCtrEncryption::TargetPerformance        = 552105;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 551585;
const uint64_t AesCtrDecryption::TargetPerformance        = 552010;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 55332;
const uint64_t AesXtsEncryption::TargetPerformance        = 54938;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 55797;
const uint64_t AesXtsDecryption::TargetPerformance        = 55478;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 11665;
const uint64_t AesGcmEncryption::TargetPerformance        = 13491;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 11727;
const uint64_t AesGcmDecryption::TargetPerformance        = 9781;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 65830;
const uint64_t AesCcmEncryption::TargetPerformance        = 64803;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 64797;
const uint64_t AesCcmDecryption::TargetPerformance        = 64563;

const uint64_t Sha1Generator::TargetPerformance           = 35577;
const uint64_t Sha256Generator::TargetPerformance         = 22630;

const uint64_t AesCmacGenerator::TargetPerformance        = 72912;
const uint64_t AesGmacGenerator::TargetPerformance        = 12022;


// Win32_VS2017
#elif defined(NN_BUILD_CONFIG_CPU_X86)

const uint64_t AesEncryption::TargetPerformanceInPlace    = 310267;
const uint64_t AesEncryption::TargetPerformance           = 300240;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 229313;
const uint64_t AesDecryption::TargetPerformance           = 228363;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 113399;
const uint64_t AesCbcEncryption::TargetPerformance        = 112583;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 219198;
const uint64_t AesCbcDecryption::TargetPerformance        = 198167;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 566789;
const uint64_t AesCtrEncryption::TargetPerformance        = 550215;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 564333;
const uint64_t AesCtrDecryption::TargetPerformance        = 550213;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 50191;
const uint64_t AesXtsEncryption::TargetPerformance        = 49842;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 49869;
const uint64_t AesXtsDecryption::TargetPerformance        = 49638;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 7268;
const uint64_t AesGcmEncryption::TargetPerformance        = 7194;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 7243;
const uint64_t AesGcmDecryption::TargetPerformance        = 7322;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 64912;
const uint64_t AesCcmEncryption::TargetPerformance        = 64226;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 64690;
const uint64_t AesCcmDecryption::TargetPerformance        = 64419;

const uint64_t Sha1Generator::TargetPerformance           = 29990;
const uint64_t Sha256Generator::TargetPerformance         = 19878;

const uint64_t AesCmacGenerator::TargetPerformance        = 72818;
const uint64_t AesGmacGenerator::TargetPerformance        = 8730;


// default (no check)
#else

const uint64_t AesEncryption::TargetPerformanceInPlace    = 0;
const uint64_t AesEncryption::TargetPerformance           = 0;
const uint64_t AesDecryption::TargetPerformanceInPlace    = 0;
const uint64_t AesDecryption::TargetPerformance           = 0;
const uint64_t AesCbcEncryption::TargetPerformanceInPlace = 0;
const uint64_t AesCbcEncryption::TargetPerformance        = 0;
const uint64_t AesCbcDecryption::TargetPerformanceInPlace = 0;
const uint64_t AesCbcDecryption::TargetPerformance        = 0;
const uint64_t AesCtrEncryption::TargetPerformanceInPlace = 0;
const uint64_t AesCtrEncryption::TargetPerformance        = 0;
const uint64_t AesCtrDecryption::TargetPerformanceInPlace = 0;
const uint64_t AesCtrDecryption::TargetPerformance        = 0;
const uint64_t AesXtsEncryption::TargetPerformanceInPlace = 0;
const uint64_t AesXtsEncryption::TargetPerformance        = 0;
const uint64_t AesXtsDecryption::TargetPerformanceInPlace = 0;
const uint64_t AesXtsDecryption::TargetPerformance        = 0;
const uint64_t AesGcmEncryption::TargetPerformanceInPlace = 0;
const uint64_t AesGcmEncryption::TargetPerformance        = 0;
const uint64_t AesGcmDecryption::TargetPerformanceInPlace = 0;
const uint64_t AesGcmDecryption::TargetPerformance        = 0;
const uint64_t AesCcmEncryption::TargetPerformanceInPlace = 0;
const uint64_t AesCcmEncryption::TargetPerformance        = 0;
const uint64_t AesCcmDecryption::TargetPerformanceInPlace = 0;
const uint64_t AesCcmDecryption::TargetPerformance        = 0;

const uint64_t Sha1Generator::TargetPerformance           = 0;
const uint64_t Sha256Generator::TargetPerformance         = 0;

const uint64_t AesCmacGenerator::TargetPerformance        = 0;
const uint64_t AesGmacGenerator::TargetPerformance        = 0;

#endif
