﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/crypto.h>

#include <nnt/nntest.h>

/*
  計測ケースの追加手順

  (1) 各 Hash 用のインターフェースを持つクラスを用意する

  (2) TeamCity のプロット用の文字列を返すインターフェースを用意する
      const char* GetName()

  (3) パフォーマンスチェック用に以下の定数を定義（定義の実体は testCrypto_PerformanceTarget.cpp に記載）
      static const uint64_t TargetPerformance

  (4) typedef ::testing::Types<*> HashTypes;
      の行の <> の中に上記のクラス名を追加する
 */


// SHA-1
class Sha1Generator : public nn::crypto::Sha1Generator
{
public:
    static const uint64_t TargetPerformance;

public:
    const char* GetName()
    {
        return "SHA-1";
    }
};

class Sha256Generator : public nn::crypto::Sha256Generator
{
public:
    static const uint64_t TargetPerformance;

public:
    const char* GetName()
    {
        return "SHA-256";
    }
};

/**
  @brief  実装クラスを定義した型です。
 */
typedef ::testing::Types<Sha1Generator, Sha256Generator> HashTypes;

