﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_RsaPssVerifier.h>
#include <nn/crypto/crypto_RsaPssSigner.h>
#include <nn/crypto/crypto_Sha1Generator.h>
#include <nn/crypto/crypto_Sha256Generator.h>
#include "RsaParser.h"

class RsaPssSigVerParser : public RsaSigVerParser
{
public:
    virtual void TestVerify( const std::string& sha,
                             const void* n, size_t nSize,
                             const void* e, size_t eSize,
                             const void* pMessage, size_t messageSize,
                             const void* pSignature, size_t signatureSize, bool expected) override
    {
        if ((nSize == 2048 / 8) || (nSize == 4096 / 8))
        {
            if (sha == "SHA1")
            {
                if ( nSize == 2048 / 8 )
                {
                    typedef nn::crypto::RsaPssVerifier<2048 / 8,
                                                        nn::crypto::Sha1Generator> Rsa2048PssSha1;
                    ASSERT_EQ( expected,
                               Rsa2048PssSha1::Verify( pSignature, signatureSize, n, nSize, e,
                                                       eSize, pMessage,
                                                       messageSize ) );
                    return;
                }
                if ( nSize == 4096 / 8 )
                {
                    typedef nn::crypto::RsaPssVerifier<4096 / 8,
                                                        nn::crypto::Sha1Generator> Rsa4096PssSha1;
                    ASSERT_EQ( expected,
                               Rsa4096PssSha1::Verify( pSignature, signatureSize, n, nSize, e,
                                                       eSize, pMessage,
                                                       messageSize ) );
                    return;
                }
            }
            if (sha == "SHA256")
            {
                if ( nSize == 2048 / 8 )
                {
                    typedef nn::crypto::RsaPssVerifier<2048 / 8,
                                                        nn::crypto::Sha256Generator>
                        Rsa2048PssSha256;
                    ASSERT_EQ( expected,
                               Rsa2048PssSha256::Verify( pSignature, signatureSize, n, nSize, e,
                                                         eSize,
                                                         pMessage, messageSize ) );
                    return;
                }
                if ( nSize == 4096 / 8 )
                {
                    typedef nn::crypto::RsaPssVerifier<4096 / 8,
                                                        nn::crypto::Sha256Generator>
                        Rsa4096PssSha256;
                    ASSERT_EQ( expected,
                               Rsa4096PssSha256::Verify( pSignature, signatureSize, n, nSize, e,
                                                         eSize,
                                                         pMessage, messageSize ) );
                    return;
                }
            }
        }

        m_Skipped = true;
    }
};

class RsaPssSigGenParser : public RsaSigGenParser
{
public:
    virtual void TestSign(const std::string& sha,
                          const void* n, size_t nSize,
                          const void* d, size_t dSize,
                          const void* pMessage, size_t messageSize,
                          void* outSignature, size_t signatureSize,
                          const std::string& expected) override
    {
        ASSERT_EQ(1u, m_UnitTokens.count(SaltVal));
        const std::string& salt = m_UnitTokens[SaltVal];
        const void* pSalt = salt.c_str();
        size_t saltSize = salt.size();

        if ((nSize == 2048 / 8) || (nSize == 4096 / 8))
        {
            if (sha == "SHA1")
            {
                if ( nSize == 2048 / 8 )
                {
                    typedef nn::crypto::RsaPssSigner<2048 / 8,
                                                      nn::crypto::Sha1Generator> Rsa2048PssSha1;
                    Rsa2048PssSha1::Sign( outSignature, signatureSize, n, nSize, d, dSize, pMessage,
                                          messageSize, pSalt, saltSize );
                    ASSERT_EQ( expected,
                               std::string(static_cast<const char*>(outSignature), signatureSize) );
                    return;
                }
                if ( nSize == 4096 / 8 )
                {
                    typedef nn::crypto::RsaPssSigner<4096 / 8,
                                                      nn::crypto::Sha1Generator> Rsa4096PssSha1;
                    Rsa4096PssSha1::Sign( outSignature, signatureSize, n, nSize, d, dSize, pMessage,
                                          messageSize, pSalt, saltSize );
                    ASSERT_EQ( expected,
                               std::string(static_cast<const char*>(outSignature), signatureSize) );
                    return;
                }
            }
            if (sha == "SHA256")
            {
                if ( nSize == 2048 / 8 )
                {
                    typedef nn::crypto::RsaPssSigner<2048 / 8,
                                                      nn::crypto::Sha256Generator> Rsa2048PssSha256;
                    Rsa2048PssSha256::Sign( outSignature, signatureSize, n, nSize, d, dSize,
                                            pMessage, messageSize, pSalt, saltSize );
                    ASSERT_EQ( expected,
                               std::string(static_cast<const char*>(outSignature), signatureSize) );
                    return;
                }
                if ( nSize == 4096 / 8 )
                {
                    typedef nn::crypto::RsaPssSigner<4096 / 8,
                                                      nn::crypto::Sha256Generator> Rsa4096PssSha256;
                    Rsa4096PssSha256::Sign( outSignature, signatureSize, n, nSize, d, dSize,
                                            pMessage, messageSize, pSalt, saltSize );
                    ASSERT_EQ( expected,
                               std::string(static_cast<const char*>(outSignature), signatureSize) );
                    return;
                }
            }
        }

        m_Skipped = true;
    }
};

TEST(RsaTest, Pss_SigGen)
{
    RsaPssSigGenParser tester;
    tester.TestFile("186-2rsatestvectors/SigGenPSS_186-2.txt",40);
}

TEST(RsaTest, Pss_SigVer)
{
    RsaPssSigVerParser tester;
    tester.TestFile("186-2rsatestvectors/SigVerPSS_186-3.rsp",72);
}
