﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs.h>
#include <cstdarg>

#ifdef ANDROID
    #define Log(...) fprintf(stderr,__VA_ARGS__)
#else
    #include <nn/nn_Log.h>
//#define LocalLog NN_LOG
    #define LocalLog ProfileLog::WriteGlobalLog
#endif

class ProfileLog
{
public:
    explicit ProfileLog( const char* fileout );
    ~ProfileLog();

    static ProfileLog* InitializeGlobalLog(const char* fileout);
    static void FinalizeGlobalLog();
    static void WriteGlobalLog(const char* format, ...);
    static void WriteGlobalVLog(const char* format, std::va_list args);

    void WriteLog(const char* format, ...);
    void WriteVLog(const char* format, std::va_list args);

private:
    void InitializeOutput(const char* fileout);

    void FinalizeOutput();

    void WriteToConsole(const char* format, ...);
    void WriteToConsole(const char* format, std::va_list args);

    void WriteToFile(const char* format, ...);
    void WriteToFile(const char* format, std::va_list args);

private:
    nn::fs::FileHandle m_outputFile;
    int64_t m_outputFileOffset;
};
