﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

class OctetString : public std::string
{
public:
    explicit OctetString( const char* hex )
        : std::string( Convert(hex) )
    {
    }
    NN_IMPLICIT operator const char* () const NN_NOEXCEPT
    {
        return c_str();
    }
    NN_IMPLICIT operator size_t () const NN_NOEXCEPT
    {
        return size();
    }

    static char IntFromHexDigit(char c)
    {
        return c <= '9' ? c - '0' : (c | 32) - 'a' + 10;
    }

    static std::string Convert(const std::string& hexStr)
    {
        std::string res;
        size_t len = hexStr.size();
        if ( len & 1)
        {
            res += IntFromHexDigit(hexStr[0]);
        }
        for (size_t i = len & 1; i < len; i += 2)
        {
            char x = IntFromHexDigit(hexStr[i]) << 4 | IntFromHexDigit(hexStr[i + 1]);
            res += x;
        }
        return res;
    }
};
