﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Aes128GcmEncryptor.h>
#include <nn/crypto/crypto_Aes128GcmDecryptor.h>
#include <nnt/nntest.h>
#include "ProfileCheck.h"
#include "OctetString.h"

static const nn::Bit8 g_Msg[] =
{
    0x3f,0xee,0xf9,0x8a,0x97,0x6a,0x1b,0xd6,0x34,0xf3,0x64,0xac,0x42,0x8b,0xb5,0x9c,
    0xd5,0x1f,0xb1,0x59,0xec,0x17,0x89,0x94,0x69,0x18,0xdb,0xd5,0x0e,0xa6,0xc9,0xd5,
    0x94,0xa3,0xa3,0x1a,0x52,0x69,0xb0,0xda,0x69,0x36,0xc2,0x9d,0x06,0x3a,0x5f,0xa2,
    0xcc,0x8a,0x1c,0x8b,0xd4,0x52,0x63,0x3f,0x9d,0xae,0x06,0x39,0xfe,0x0e,0x67,0xe3,
    0x64,0x01,0xad,0xf6,0x5b,0x3e,0xdf,0x67,0x99,0xff,0x9e,0xec,0x80,0xd8,0x5c,0x13,
    0xc8,0x5e,0x0e,0xe0,0x94,0x91,0xd4,0xf5,0xac,0xaf,0x8a,0xe9,0x20,0x28,0x18,0x01,
    0xa2,0xf5,0xd1,0x2c,0x93,0x70,0x5b,0x33,0x5b,0xe9,0x7a,0x86,0xc8,0xc1,0xa2,0x9b,
    0x74,0x08,0x83,0x3f,0x75,0x2c,0x8c,0x5d,0x4c,0x91,0x2e,0x7f,0x26,0xc7,0x3b,0x90,
    0x92,0x39,0xe1,0x22,0x2f,0xc8,0x51,0xb4,0xe3,0xc0,0xac,0xcc,0x51,0x48,0xcc,0x60,
    0xaf,0x2f,0x01,0x9f,0x9e,0xe0,0x06,0x01,0x31,0x77,0xec,0x68,0xb5,0x1f,0x5e,0xb0,
    0xf2,0xd8,0x0d,0x3a,0xf6,0x96,0x62,0x7f,0x36,0x5b,0x6e,0x83,0xe6,0x9f,0x10,0x5c,
    0x7b,0xad,0x8e,0x48,0x69,0xb2,0x28,0xa0,0xc4,0x96,0xaa,0x05,0xc9,0x6e,0x97,0xa6,
    0xbf,0xcb,0x33,0xaa,0x17,0x2f,0x22,0xc6,0xbf,0x3d,0x51,0x16,0xc1,0xeb,0xd9,0x68,
    0xd8,0x61,0xfd,0xdf,0xfa,0xb4,0x18,0x57,0xde,0x70,0x49,0xbd,0xee,0x73,0xac,0xfe,
    0xa5,0x56,0x4c,0xf4,0x4c,0xe4,0x0d,0x75,0xb9,0x60,0xca,0x54,0x53,0xcd,0xa0,0x93,
    0xa5,0x5c,0x55,0x27,0x68,0x7f,0x25,0x43,0x3b,0xd6,0xdc,0xde,0x44,0x30,0x30,0x9d,
    0x8a,0xb6,0x77,0x4c,0xbf,0x48,0x6f,0xc4,0x37,0x8a,0x05,0xa7,0xaa,0xbb,0xa7,0xba,
    0x7f,0xf4,0xa0,0xf5,0xee,0xb5,0x1c,0x54,0xc2,0xae,0x9a,0x5d,0xd8,0x29,0xd2,0x73,
    0x50,0x89,0x95,0x5d,0x5a,0xe2,0x40,0xd2,0x8d,0xa8,0xb7,0x99,0x94,0xcd,0x72,0x23,
    0x4e,0xe6,0xd9,0x52,0x88,0x56,0xdb,0x08,0x78,0x49,0x26,0x4a,0xc8,0x11,0x68,0x94,
    0x20,0xef,0x2b,0xee,0xa9,0xc6,0x76,0x76,0x44,0xf3,0xca,0x8b,0xfc,0x63,0x45,0xa3,
    0xe2,0xe5,0xc4,0x9e,0x7e,0x0f,0xd9,0xb1,0xc2,0xe1,0x67,0x1b,0xd1,0xb6,0x27,0x5b,
    0x0b,0xd4,0x33,0x06,0xc5,0xe5,0x33,0x18,0x0c,0x0c,0x73,0xd7,0x57,0x99,0x02,0x53,
    0x03,0xd6,0x60,0xe4,0x3d,0x57,0x95,0xad,0x46,0xb8,0x4a,0x05,0x74,0x1b,0x44,0x1f,
    0x85,0x5e,0xee,0xa2,0x99,0xa6,0x48,0x4c,0x17,0xf3,0x9e,0x88,0x4a,0xee,0x28,0xb7,
    0xd3,0x84,0xaf,0xb4,0x9c,0x13,0x4c,0x73,0x9e,0x76,0x1d,0x4b,0x7b,0xdc,0xe2,0xb8,
    0x51,0xe5,0x08,0xf7,0x7f,0xaf,0xf4,0x7f,0xf8,0x35,0x05,0x75,0x54,0x94,0xf1,0xbb,
    0x51,0x69,0xdc,0x23,0xbb,0x02,0xd9,0xba,0x8f,0xb8,0xb4,0x87,0x8c,0x8a,0x47,0xdf,
    0xd1,0x4e,0xa0,0xdc,0xef,0x3e,0x83,0xc6,0x88,0xe5,0x97,0x6a,0x3a,0x1a,0x98,0x15,
    0x69,0x01,0x06,0xd1,0x90,0x8b,0xc7,0xe6,0xe3,0x25,0xbf,0xd8,0x01,0x90,0x0e,0x94,
    0xa9,0xfb,0xc2,0x8b,0x6d,0x52,0xb8,0xf9,0xb4,0xde,0x70,0x03,0xb0,0x66,0xbb,0xb1,
    0x8b,0xba,0x33,0xda,0x83,0xc6,0x78,0x09,0xe3,0xbc,0xf9,0x8b,0x5c,0xbc,0xb8,0xcb
};

static const nn::Bit8 g_Iv[] =
{
    0x49,0xb1,0x20,0x54,0x08,0x26,0x60,0x80,0x3a,0x1d,0xf3,0xdf
};

static const nn::Bit8 g_Key[16] =
{
    0x59,0x41,0x57,0xec,0x46,0x93,0x20,0x2b,0x03,0x0f,0x33,0x79,0x8b,0x07,0x17,0x6d
};


TEST(Aes128Gcm, Encrypt_Profile)
{
    nn::Bit8 ct[sizeof(g_Msg)];
    nn::Bit8 mac[nn::crypto::Aes128GcmEncryptor::MacSize];

    {
        static const int Repeat = 10;
        PROFILE_CHECK_Win("AES-128-GCM/Encrypt", -1, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch32("AES-128-GCM/Encrypt", 25, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch64("AES-128-GCM/Encrypt",  3, -1, -1, -1, Repeat);
        nn::crypto::Aes128GcmEncryptor enc;
        enc.Initialize(g_Key, sizeof(g_Key), g_Iv, sizeof(g_Iv));
        for ( int i = Repeat; i--; )
        {
            enc.Update(ct, sizeof(ct), g_Msg, sizeof(g_Msg));
            enc.GetMac(mac, sizeof(mac));
            if (i != 0)
                enc.Reset(g_Iv, sizeof(g_Iv));
        }
    }
}


TEST(Aes128Gcm, Decrypt_Profile)
{
    nn::Bit8 pt[sizeof(g_Msg)];
    nn::Bit8 mac[nn::crypto::Aes128GcmEncryptor::MacSize];

    {
        static const int Repeat = 10;
        PROFILE_CHECK_Win("AES-128-GCM/Decrypt", -1, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch32("AES-128-GCM/Decrypt", 22, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch64("AES-128-GCM/Decrypt",  2, -1, -1, -1, Repeat);
        nn::crypto::Aes128GcmEncryptor enc;
        enc.Initialize(g_Key, sizeof(g_Key), g_Iv, sizeof(g_Iv));
        for ( int i = Repeat; i--; )
        {
            enc.Update(pt, sizeof(pt), g_Msg, sizeof(g_Msg));
            enc.GetMac(mac, sizeof(mac));
            if (i != 0)
                enc.Reset(g_Iv, sizeof(g_Iv));
        }
    }
}


TEST(Aes128Gcm, Hash_Profile)
{
    nn::Bit8 mac[nn::crypto::Aes128GcmEncryptor::MacSize];

    {
        static const int Repeat = 10;
        PROFILE_CHECK_Win("AES-128-GCM/Hash", -1, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch32("AES-128-GCM/Hash", 14, -1, -1, -1, Repeat);
        PROFILE_CHECK_OsHorizon_AArch64("AES-128-GCM/Hash",  1, -1, -1, -1, Repeat);
        nn::crypto::Aes128GcmEncryptor enc;
        enc.Initialize(g_Key, sizeof(g_Key), g_Iv, sizeof(g_Iv));
        for ( int i = Repeat; i--; )
        {
            enc.UpdateAad(g_Msg, sizeof(g_Msg));
            enc.GetMac(mac, sizeof(mac));
            if (i != 0)
                enc.Reset(g_Iv, sizeof(g_Iv));
        }
    }
}
