﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/crypto/crypto_Aes128CmacGenerator.h>
#include <cstring>
#include <cstdlib>

#include <nnt/nntest.h>
#include "CavsParser.h"
#include "ProfileCheck.h"
#include "OctetString.h"

class CmacParser : public CavsParser
{
public:
    enum
    {
        Count,
        DataUnitLen,
        MacLen,
        Key,
        Message,
        Mac
    };

    CmacParser()
    {
        m_AllowedTokens[Count]       = AllowedToken("Count = ", false);
        m_AllowedTokens[DataUnitLen] = AllowedToken("Mlen = ",  false);
        m_AllowedTokens[MacLen]      = AllowedToken("Tlen = ",  false);
        m_AllowedTokens[Key]         = AllowedToken("Key = ",   true);
        m_AllowedTokens[Message]     = AllowedToken("Msg = ",   true);
        m_AllowedTokens[Mac]         = AllowedToken("Mac = ",   true);
        m_TokenForUnitComplete       = Key;
    }

    virtual void TestUnit() override
    {
        ASSERT_EQ(m_UnitTokens.count(DataUnitLen), 1);
        ASSERT_EQ(m_UnitTokens.count(Key), 1);
        ASSERT_EQ(m_UnitTokens.count(Message), 1);
        ASSERT_EQ(m_UnitTokens.count(Mac), 1);

        const std::string& keyStr   = m_UnitTokens[Key];
        const std::string& msgStr   = m_UnitTokens[Message];
        const std::string& macStr   = m_UnitTokens[Mac];

        // generate full MAC first
        std::string resMac(16, char(0));
        nn::crypto::GenerateAes128Cmac(const_cast<char*>(resMac.c_str()), resMac.size(),
                                       msgStr.c_str(), std::atoi(m_UnitTokens[DataUnitLen].c_str()),
                                       keyStr.c_str(), keyStr.size());

        // then resize to speficied Tlen in order for compare
        resMac.resize(macStr.size());

        ASSERT_TRUE(resMac == macStr);

        m_UnitTokens.erase( Key );
    }
};

TEST(Aes128Cmac, rsp)
{
    CmacParser tester;
    tester.TestFile("CmacTestVectors/CMACGenAES128.rsp", 96);
}
