﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include <nn/nn_Common.h>

#include <nn/os.h>

#include <nn/i2c/i2c.h>
#include <nn/cpad/cpad.h>
#include <nnt/gtest/gtest.h>

namespace {

const int            g_TestCount   = 1000;   // コントローラデータ取得テストの回数
const int            g_StatesCount = 3;     // 入力変化検知の状態列の長さ
const size_t         g_StateSize   = 16;    // バッファサイズ

nn::cpad::CpadState  g_States[g_StateSize]; // コントローラ入力用のバッファ

// 入力をダンプする
void DumpInput(nn::cpad::CpadState state)
{
    NN_LOG("L(%d, %d) R(%d, %d)",
        state.stickL.x, state.stickL.y,
        state.stickR.x, state.stickR.y
    );

    if( state.buttons.Get<nn::cpad::CpadButton::A>()      )
    {
        NN_LOG("A ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::B>()      )
    {
        NN_LOG("B ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::X>()      )
    {
        NN_LOG("X ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Y>()      )
    {
        NN_LOG("Y ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::L>()      )
    {
        NN_LOG("L ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::R>()      )
    {
        NN_LOG("R ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::ZL>()     )
    {
        NN_LOG("ZL ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::ZR>()     )
    {
        NN_LOG("ZR ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Start>()  )
    {
        NN_LOG("Start ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Select>() )
    {
        NN_LOG("Select ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Home>()   )
    {
        NN_LOG("Home ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Left>()   )
    {
        NN_LOG("Left ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Up>()     )
    {
        NN_LOG("Up ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Right>()  )
    {
        NN_LOG("Right ");
    }

    if( state.buttons.Get<nn::cpad::CpadButton::Down>()   )
    {
        NN_LOG("Down ");
    }


    NN_LOG("\n");
}


} // namespace


/**
 * I2C ドライバライブラリの基礎的な送受信機能を確認するテスト。
 * 実機上で本プログラムは実行されることを想定しています。
 * テストに用いる対向デバイスはクラシックコントローラとなります。
 */
TEST( Basic, All )
{
    nn::cpad::InitializeCpad();

    for(int i = 0; i < g_TestCount; i++ )
    {
        auto result = nn::cpad::GetCpadState(g_States);
        ASSERT_TRUE(result.IsSuccess());

        if( nn::cpad::HasCpadChange( g_States, g_StatesCount) )
        {
            NN_LOG("Change>");
        }

        if( nn::cpad::HasCpadInput(g_States[0]) )
        {
            NN_LOG("Input>");
        }

        if( g_States[0].buttons.Get<nn::cpad::CpadButton::A>()      )
        {
            nn::cpad::CalibrateCpad();
        }

        DumpInput(g_States[0]);

    }
}
