﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/nn_Assert.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ConsumableServiceItem {

const int IdLength = 17;
const int CountryLength = 3;

struct Right
{
    char rightId[IdLength];
    char nsaId[IdLength];
    char itemId[IdLength];
    long purchasedDataTime;
    char country[CountryLength];
};

//! 権利取得 API
Result GetRights(Right* pOutRights, int* pOutRightCount, const int maxRightCount, const char* applicationId, const char* nsaId) NN_NOEXCEPT;

//! 権利消費 API
Result ConsumeRight(const char* rightId, const char* applicationId, const char* nsaId) NN_NOEXCEPT;

}
}
