﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/vi/testVi_TestServerProxy.h>

#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>

namespace nnt{ namespace vi{

    TestServiceProxy::TestServiceProxy() NN_NOEXCEPT
        : m_ClientManager(NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER)
        , m_ServiceHolder(NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER)
    {
    }

    TestServiceProxy::~TestServiceProxy() NN_NOEXCEPT
    {
    }


    nn::Result TestServiceProxy::Initialize() NN_NOEXCEPT
    {
        bool isSuccess = false;

        NN_RESULT_DO(InitializeServiceImpl());
        NN_UTIL_SCOPE_EXIT {
            if(!isSuccess)
            {
                FinalizeServiceImpl();
            }
        };

        isSuccess = true;
        NN_RESULT_SUCCESS;
    }

    void TestServiceProxy::Finalize() NN_NOEXCEPT
    {
        FinalizeServiceImpl();
    }

    //------------------------------------------------------------

    nn::Result TestServiceProxy::InitializeServiceImpl() NN_NOEXCEPT
    {
        bool isSuccess = false;

        NN_RESULT_DO(m_ClientManager.InitializeShimLibraryHolder(&m_ServiceHolder, ServiceName));
        NN_UTIL_SCOPE_EXIT {
            if(!isSuccess)
            {
                m_ServiceHolder.FinalizeHolder();
            }
        };

        isSuccess = true;
        NN_RESULT_SUCCESS;
    }

    void TestServiceProxy::FinalizeServiceImpl() NN_NOEXCEPT
    {
        m_ServiceHolder.FinalizeHolder();
    }

    //------------------------------------------------------------

    nn::sf::SharedPointer<Service> TestServiceProxy::GetService() NN_NOEXCEPT
    {
        return m_ServiceHolder.GetObject();
    }

}}
