﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/result/testResult_Assert.h>

#include <nn/util/util_FormatString.h>

namespace {
    /**
        @brief
            nn::Result をエラー表示用の文字列として出力します。
            PrintResult が実装されるまでの代替メソッドです。
        @param[in] result
            表示対象となる、nn::Result の値です。
        @param[in] assertionResult
            出力先です。
    */
    void PrintTo(::testing::AssertionResult& assertionResult, const nn::Result& result)
    {
        // result.GetInnerValueForDebug を8桁の16進数文字列に変換
        const size_t hexDigits = 8; // 16進数での桁数
        char hexString[hexDigits + 1];
        nn::util::SNPrintf(hexString, sizeof(hexString), "%08x", result.GetInnerValueForDebug());

        if (result.IsSuccess())
        {
            assertionResult << "nn::ResultSuccess";
        }
        else
        {
            assertionResult << "UnknownResult";
        }
        assertionResult << "(0x" << hexString << ", module=" << result.GetModule() << ", desc=" << result.GetDescription() <<  ")";
    }
}

namespace nn {

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    void PrintTo(const nn::Result& result, ::std::ostream* os)
#elif defined(NN_BUILD_CONFIG_COMPILER_GCC) || defined(NN_BUILD_CONFIG_COMPILER_CLANG)
    void PrintTo(const nn::Result& result, ::nnt::testing::detail::StringStream* os)
#endif
    {
        // result.GetInnerValueForDebug を8桁の16進数文字列に変換
        const size_t hexDigits = 8; // 16進数での桁数
        char hexString[hexDigits + 1];
        nn::util::SNPrintf(hexString, sizeof(hexString), "%08x", result.GetInnerValueForDebug());

        if (result.IsSuccess())
        {
            *os << "nn::ResultSuccess";
        }
        else
        {
            *os << "UnknownResult";
        }
        *os << "(0x" << hexString << ", module=" << result.GetModule() << ", desc=" << result.GetDescription() <<  ")";
    }

}


namespace nnt { namespace result { namespace detail {

    ::testing::AssertionResult IsResultSuccess(const char* expr, nn::Result result)
    {
        if (result.IsSuccess())
        {
            return ::testing::AssertionSuccess();
        }
        else
        {
            ::testing::AssertionResult assertionResult = ::testing::AssertionFailure();

            assertionResult << "\n"
                << "Value of: " << expr << "\n"
                << "  Actual: ";
            ::PrintTo(assertionResult, result); // TODO: PrintResult が実装されたら置き換える

            assertionResult << "\n"
                << "Expected: ";
            ::PrintTo(assertionResult, nn::Result(nn::ResultSuccess())); // TODO: PrintResult が実装されたら置き換える

            return assertionResult;
        }
    }

    ::testing::AssertionResult IncludeResultImpl(const char* expectedExpression, const char* resultExpression, bool (*isExpected)(nn::Result), nn::Result expectedResult, nn::Result result)
    {
        NN_UNUSED(expectedExpression);
        if (isExpected(result))
        {
            return ::testing::AssertionSuccess();
        }
        else
        {
            ::testing::AssertionResult assertionResult = ::testing::AssertionFailure();

            assertionResult << "\n"
                << "Value of: " << resultExpression << "\n"
                << "  Actual: ";
            ::PrintTo(assertionResult, result); // TODO: PrintResult が実装されたら置き換える

            assertionResult << "\n"
                << "Expected: ";
            ::PrintTo(assertionResult, expectedResult); // TODO: PrintResult が実装されたら置き換える

            return assertionResult;
        }
    }

}}}
