﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gfx/testGfx_ScreenCapture.h>

//------------------------------------------------------------------------------
//  コンストラクタ
//------------------------------------------------------------------------------
NntGfxScreenCapture::NntGfxScreenCapture()
    : m_HeapHandle(NULL), /*m_pFrameBuffer(),*/ m_Width(), m_Height(), m_pRgbPixels()
{
    m_pColorConvertPixels = NULL;
    m_pColorConvertBuffer = NULL;

    m_pTilingConvertPixels = NULL;
    m_pTilingConvertBuffer = NULL;
}

//------------------------------------------------------------------------------
//  デストラクタ
//------------------------------------------------------------------------------
NntGfxScreenCapture::~NntGfxScreenCapture()
{
    assert( m_pColorConvertPixels == NULL );
    assert( m_pColorConvertBuffer == NULL );

    assert( m_pTilingConvertPixels == NULL );
    assert( m_pTilingConvertBuffer == NULL );

    assert( m_pRgbPixels == NULL );
}

//------------------------------------------------------------------------------
//  初期化処理
//------------------------------------------------------------------------------
void NntGfxScreenCapture::Initialize( nn::lmem::HeapHandle pHeapHandle )
{
    m_HeapHandle = pHeapHandle;
    //m_pFrameBuffer = pFrameBuffer;

    /*m_width  = static_cast<int>( m_pFrameBuffer->GetSize().x );
    m_height = static_cast<int>( m_pFrameBuffer->GetSize().y );*/

    // RGBデータを作成
    m_pRgbPixels = static_cast<uint8_t*>(nn::lmem::AllocateFromExpHeap(m_HeapHandle, m_Width * m_Height * 3));

    // 色変換バッファを作成
    //m_pColorConvertBuffer = static_cast<GX2ColorBuffer*>( pHeap->Alloc( sizeof( GX2ColorBuffer ) ) );
    m_pColorConvertBuffer = static_cast<GX2ColorBuffer*>( nn::lmem::AllocateFromExpHeap(m_HeapHandle, sizeof( GX2ColorBuffer )) );
    GX2InitColorBuffer( m_pColorConvertBuffer, m_Width, m_Height, GX2_SURFACE_FORMAT_TCS_R8_G8_B8_A8_UNORM, GX2_AA_MODE_1X );

    //m_pColorConvertPixels = static_cast<u8*>( pHeap->Alloc( m_pColorConvertBuffer->surface.imageSize, m_pColorConvertBuffer->surface.alignment ) );
    m_pColorConvertPixels = static_cast<uint8_t*>(nn::lmem::AllocateFromExpHeap( m_HeapHandle, m_pColorConvertBuffer->surface.imageSize, m_pColorConvertBuffer->surface.alignment ));
    GX2InitColorBufferPtr( m_pColorConvertBuffer, m_pColorConvertPixels );

    // タイリング変換バッファを作成
    //m_pTilingConvertBuffer = static_cast<GX2ColorBuffer*>( pHeap->Alloc( sizeof( GX2ColorBuffer ) ) );
    m_pTilingConvertBuffer = static_cast<GX2ColorBuffer*>( nn::lmem::AllocateFromExpHeap(m_HeapHandle, sizeof( GX2ColorBuffer ) ) );
    GX2InitColorBuffer( m_pTilingConvertBuffer, m_Width, m_Height, GX2_SURFACE_FORMAT_TCS_R8_G8_B8_A8_UNORM, GX2_AA_MODE_1X );

    //m_pTilingConvertPixels = static_cast<u8*>( pHeap->Alloc( m_pTilingConvertBuffer->surface.imageSize, m_pTilingConvertBuffer->surface.alignment ) );
    m_pTilingConvertPixels = static_cast<uint8_t*>( nn::lmem::AllocateFromExpHeap( m_HeapHandle, m_pTilingConvertBuffer->surface.imageSize, m_pTilingConvertBuffer->surface.alignment ) );
    GX2InitColorBufferPtr( m_pTilingConvertBuffer, m_pTilingConvertPixels );

    m_pTilingConvertBuffer->surface.tileMode = GX2_TILE_MODE_LINEAR_SPECIAL;
}

//------------------------------------------------------------------------------
//  破棄処理
//------------------------------------------------------------------------------
void NntGfxScreenCapture::Release()
{
    // RGBデータを破棄
    nn::lmem::FreeToExpHeap(m_HeapHandle, m_pRgbPixels);
    m_pRgbPixels = NULL;

    // 色変換バッファを破棄
    //m_pHeap->Free( m_pColorConvertBuffer );
    nn::lmem::FreeToExpHeap(m_HeapHandle, m_pColorConvertBuffer);
    m_pColorConvertBuffer = NULL;

    //m_pHeap->Free( m_pColorConvertPixels );
    nn::lmem::FreeToExpHeap(m_HeapHandle, m_pColorConvertPixels);
    m_pColorConvertPixels = NULL;

    // タイリング変換バッファを破棄
    //m_pHeap->Free( m_pTilingConvertBuffer );
    nn::lmem::FreeToExpHeap(m_HeapHandle, m_pTilingConvertBuffer);
    m_pTilingConvertBuffer = NULL;

    //m_pHeap->Free( m_pTilingConvertPixels );
    nn::lmem::FreeToExpHeap(m_HeapHandle, m_pTilingConvertPixels);
    m_pTilingConvertPixels = NULL;
}

//---------------------------------------------------------------------------
//  キャプチャ画像の横幅を取得
//---------------------------------------------------------------------------
int NntGfxScreenCapture::GetWidth() const
{
    return m_Width;
}

//---------------------------------------------------------------------------
//  キャプチャ画像の縦幅を取得
//---------------------------------------------------------------------------
int NntGfxScreenCapture::GetHeight() const
{
    return m_Height;
}

//---------------------------------------------------------------------------
//  ピクセルデータを取得
//---------------------------------------------------------------------------
const uint8_t* NntGfxScreenCapture::GetPixels() const
{
    return m_pRgbPixels;
}

//---------------------------------------------------------------------------
//  キャプチャ処理
//---------------------------------------------------------------------------
void NntGfxScreenCapture::Capture()
{
    // レンダーステートの設定
    GX2SetAlphaTest(GX2_DISABLE, GX2_COMPARE_LESS, 0.0f);
    GX2SetColorControl( GX2_LOGIC_OP_COPY, 0, GX2_DISABLE, GX2_ENABLE );

    // うまくキャプチャされないときはレンダーステートをデフォルトにして試してください
    // GX2SetDefaultState();

    // キャッシュをフラッシュ
    // フラッシュしないとキャプチャ画像にノイズがのる場合がある
    GX2InvalidateType type = GX2InvalidateType(GX2_INVALIDATE_COLOR_BUFFER | GX2_INVALIDATE_CPU);
    GX2Invalidate(type, m_pColorConvertBuffer->surface.imagePtr, m_pColorConvertBuffer->surface.imageSize);
    GX2Invalidate(type, m_pTilingConvertBuffer->surface.imagePtr, m_pTilingConvertBuffer->surface.imageSize);

    // フレームバッファのカラーフォーマットを変換
    GX2ColorBuffer* pFrameColorBuffer = m_pFrameBuffer->GetGX2ColorBuffer();
    GX2UTCopySurface( &pFrameColorBuffer->surface, 0, 0, &m_pColorConvertBuffer->surface, 0, 0 );

    GX2DrawDone();

    // フレームバッファのタイリングを解除
    GX2CopySurface( &m_pColorConvertBuffer->surface, 0, 0, &m_pTilingConvertBuffer->surface, 0, 0 );

    // RGBAデータをRGBデータに変換
    for (int y = 0; y < m_Height; ++y)
    {
        for (int x = 0; x < m_Width; ++x)
        {
            int srcIndex = y * m_Width * 4 + x * 4;
            int dstIndex = y * m_Width * 3 + x * 3;

            m_pRgbPixels[dstIndex + 0] = m_pTilingConvertPixels[srcIndex + 0];
            m_pRgbPixels[dstIndex + 1] = m_pTilingConvertPixels[srcIndex + 1];
            m_pRgbPixels[dstIndex + 2] = m_pTilingConvertPixels[srcIndex + 2];
        }
    }
}
