﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <sstream>
#include <fstream>
#include <nn/fs.h>
#include <nnt/gfx/testGfx_ResultHtml.h>
#include <nnt/gfx/testGfx_FileSystem.h>

namespace nnt {
namespace gfx {

//------------------------------------------------------------------------------
//  HTML作成
//------------------------------------------------------------------------------
bool NntGfxResultHtml::CreateResultHtml( const char* pPath  )
{
    int tableCount = m_TableArray.size();
    if (tableCount <= 0)
    {
        return false;
    }

    std::stringstream sStream;

    sStream << "<html>" << std::endl;
    sStream << "<body>" << std::endl;

    for ( int i = 0; i < tableCount; i++ )
    {
        Table table = m_TableArray.at(i);

        sStream << "<h4>" << table.headerName.c_str() << "</h4>" << std::endl;
        sStream << "<table border=\"1\">" << std::endl;

        int lineCount = table.lineArray.size();
        for ( int j = 0; j < lineCount; j++ )
        {
            TableLine tableLine = table.lineArray.at(j);
            int dataCount = tableLine.dataArray.size();

            sStream << "<tr>" << std::endl;

            for ( int n = 0; n < dataCount; n++ )
            {
                TableData data = tableLine.dataArray.at(n);

                sStream << "    <td width=\"" << data.width << "\" height=\"" << data.height << "\" align=\"center\">" << data.outValue.c_str() << "</td>" << std::endl;
            }

            sStream << "</tr>" << std::endl;
        }
        sStream << "</table>" << std::endl << std::endl;
    }

    sStream << "</html>" << std::endl;
    sStream << "</body>" << std::endl;

    // ファイルを開く
    std::ofstream ofs;
    ofs.open( pPath, std::ios::out | std::ios::binary );

    // データを保存する
    ofs.write( reinterpret_cast<const char*>( sStream.str().c_str() ), sStream.str().size() );

    // ファイルを閉じる
    ofs.close();

    return true;
}


}
}
