﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <zlib.h>
#include <nn/fs.h>
#include <nnt/gfx/testGfx_FileSystem.h>
#include <nnt/gfx/testGfx_PngIO.h>

namespace nnt {
namespace gfx {

//------------------------------------------------------------------------------
//  32bitデータをストリームに出力
//------------------------------------------------------------------------------
void NntGfxPngIO::Output32( std::ostream* pStream, const void* pData, uint32_t* pCrc )
{
    // ビッグエンディアンになるようにWin版のみフリップ
    const uint8_t* pBytes = reinterpret_cast<const uint8_t*>( pData );
    uint32_t data;
    for ( int i = 0; i < 4; ++i )
    {
        data = data << 8 | pBytes[i];
    }

    pStream->write( reinterpret_cast<const char*>( &data ), 4 );

    if (pCrc != NULL)
    {
        *pCrc = crc32( *pCrc, reinterpret_cast<const Bytef*>( &data ), 4 );
    }
}

//------------------------------------------------------------------------------
//  圧縮率を上げるため画像にフィルターをかける
//------------------------------------------------------------------------------
void NntGfxPngIO::CompressFilter( const uint8_t* pInput, int width, int height, uint8_t pixelBytes, uint8_t* pOutput )
{
    for ( int y = 0; y < height; ++y )
    {
        int rowBytes = width * pixelBytes;

        // Win版はOpenGLの仕様に合わせて上下反転させる
        const uint8_t* pInputLine = &pInput[(height - 1 - y) * rowBytes];
        uint8_t* pOutputLine = &pOutput[y * ( 1 + rowBytes )];

        pOutputLine[0] = 0;

        for ( int x = 0; x < rowBytes; ++x )
        {
            pOutputLine[1 + x] = pInputLine[x];
        }
    }
}

//------------------------------------------------------------------------------
// 32bitデータをストリームから入力
//------------------------------------------------------------------------------
uint32_t NntGfxPngIO::Input32( uint8_t** pStream )
{
    uint32_t data;
    memcpy( &data, *pStream, 4 );

    // リトルエンディアンになるようにWin版のみフリップ
    uint32_t temp = data;
    data = 0;
    const uint8_t* pBytes = reinterpret_cast<const uint8_t*>( &temp );
    for ( int i = 0; i < 4; ++i )
    {
        data = data << 8 | pBytes[i];
    }

    *pStream = *pStream + 4;

    return data;
}

//------------------------------------------------------------------------------
// フィルタを適用したピクセルデータを復元
//------------------------------------------------------------------------------
void NntGfxPngIO::DecompressFilter( const uint8_t* pInput, int width, int height, uint8_t pixelBytes, uint8_t* pOutput )
{
    for ( int y = 0; y < height; ++y )
    {
        // Win版はOpenGLの仕様に合わせて上下反転させる
        const uint8_t* pInputLine = &pInput[y * ( 1 + width * pixelBytes )];
        uint8_t* pOutputLine = &pOutput[(height - 1 - y) * ( width * pixelBytes )];

        for ( int x = 0; x < width * pixelBytes; ++x )
        {
            pOutputLine[x] = pInputLine[1 + x];
        }
    }
}

}
}
