﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdint>
#include <cstddef>
#include <algorithm>

#include <nnt.h>
#include <nn/os.h>

#include <nn/codec.h>
#include <nn/codec/detail/codec_OpusPacketInternal.h> // nn::codec::detail::OpusPacketInternal

/**
 * @brief       OpusPacket() の正常系テストです。
 */
TEST(OpusPacket, Success)
{
    const std::size_t testSizes[] = {
        0,
        1,
        2,
        static_cast<std::size_t>(nn::codec::OpusPacketSizeMaximum - nn::codec::detail::OpusPacketInternal::HeaderSize),
        static_cast<std::size_t>(nn::codec::OpusPacketSizeMaximum - nn::codec::detail::OpusPacketInternal::HeaderSize + 1),
    };
    for (auto testSize : testSizes)
    {
        // 準備
        const size_t packetSize = nn::codec::detail::OpusPacketInternal::HeaderSize * 2;
        uint8_t packet[packetSize];
        nn::codec::detail::OpusPacketInternal::Header header = { 0, };
        header.packetSize = static_cast<uint32_t>(testSize);
        nn::codec::detail::OpusPacketInternal::SetHeaderInPacket(packet, header);
        // チェック

        const std::size_t expected = testSize > nn::codec::OpusPacketSizeMaximum - nn::codec::detail::OpusPacketInternal::HeaderSize ?
            0 : testSize + nn::codec::detail::OpusPacketInternal::HeaderSize;
        EXPECT_EQ(expected, nn::codec::GetOpusPacketSize(packet, packetSize));
    }
}


/**
 * @brief       OpusPacket() の事前条件テストです。
 */
#if !defined(NN_SDK_BUILD_RELEASE)
TEST(OpusPacket, PreCondition)
{
    // 準備 (共通部分)
    const size_t packetSize = nn::codec::detail::OpusPacketInternal::HeaderSize;
    uint8_t packet[packetSize];
    // nullptr
    EXPECT_DEATH_IF_SUPPORTED(nn::codec::GetOpusPacketSize(nullptr, packetSize), "");
    // サイズ不足
    EXPECT_DEATH_IF_SUPPORTED(nn::codec::GetOpusPacketSize(packet, static_cast<std::size_t>(nn::codec::detail::OpusPacketInternal::HeaderSize - 1)), "");
}
#endif // !defined(NN_SDK_BUILD_RELEASE)
