﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testCapsrv_MakerNoteForTestFoundation.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "../../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_Signature.h"
#include "../../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteValuePropertyUtility.h"

namespace nnt{ namespace capsrv{
    const uint32_t MakerNoteInfo::Integer0Default;
    const uint32_t MakerNoteInfo::Integer1Default;
    const uint32_t MakerNoteInfo::Integer2ReqDefault;
    const uint32_t MakerNoteInfo::Integer2OptDefault;
    const uint32_t MakerNoteInfo::Integer3ReqDefault;
    const uint32_t MakerNoteInfo::Integer3OptDefault;
}}

namespace nnt{ namespace capsrv{

    class MakerNoteForFoundationTestTag;

    struct MakerNoteEncryptionPolicyNone
    {
        static const int Version = 0;
        static const size_t UnitSize = 1;

        static void EncryptInplace(void*, size_t, ptrdiff_t) NN_NOEXCEPT
        {
            return;
        }

        static void DecryptInplace(void*, size_t, ptrdiff_t) NN_NOEXCEPT
        {
            return;
        }
    };

    // 各 MakerNoteVersion のポリシー型
    struct MakerNoteVersionPolicyV0
    {
        static const uint32_t Version = nnt::capsrv::MakerNoteVersion_Version0;

        static const bool IsErrorOnUnknownEntryEnabled = true;
        static const size_t    SizeMin = 1;
        static const size_t    SizeMax = 4096;

        static const ptrdiff_t EncryptionStartOffset = 0;
        typedef nnt::capsrv::MakerNoteEncryptionPolicyNone EncryptionPolicy;
    };

    struct MakerNoteVersionPolicyV1
    {
        static const uint32_t Version = nnt::capsrv::MakerNoteVersion_Version1;

        static const bool IsErrorOnUnknownEntryEnabled = true;
        static const size_t    SizeMin = 1;
        static const size_t    SizeMax = 4096;

        static const ptrdiff_t EncryptionStartOffset = 0;
        typedef nnt::capsrv::MakerNoteEncryptionPolicyNone EncryptionPolicy;
    };

    struct MakerNoteVersionPolicyV2
    {
        static const uint32_t Version = nnt::capsrv::MakerNoteVersion_Version2;

        static const bool IsErrorOnUnknownEntryEnabled = false;
        static const size_t    SizeMin = 1;
        static const size_t    SizeMax = 4096;

        static const ptrdiff_t EncryptionStartOffset = 0;
        typedef nnt::capsrv::MakerNoteEncryptionPolicyNone EncryptionPolicy;
    };

    struct MakerNoteVersionPolicyV3
    {
        static const uint32_t Version = nnt::capsrv::MakerNoteVersion_Version3;

        static const bool IsErrorOnUnknownEntryEnabled = false;
        static const size_t    SizeMin = 1;
        static const size_t    SizeMax = 4096;

        static const ptrdiff_t EncryptionStartOffset = 0;
        typedef nnt::capsrv::MakerNoteEncryptionPolicyNone EncryptionPolicy;
    };


#define NN_CAPSRV_DETAIL_FOREACH_MAKERNOTEVERSIONPOLICY(macro)    \
    macro(nnt::capsrv::MakerNoteVersionPolicyV0)    \
    macro(nnt::capsrv::MakerNoteVersionPolicyV1)    \
    macro(nnt::capsrv::MakerNoteVersionPolicyV2)    \
    macro(nnt::capsrv::MakerNoteVersionPolicyV3)    \
    //

    //-------------------------------------------------------
    // MakerNoteEntry の定義
    //-------------------------------------------------------

    class MakerNoteValueProperty
        : public nn::capsrv::server::detail::MakerNoteValuePropertyUtility
    {
    public:
        struct Integer0Property
            : TagDefinition<MakerNoteEntryTag_Integer0>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer0, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer0Default, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version0, 1, 1, void>
        {};

        struct Bytes0Property
            : TagDefinition<MakerNoteEntryTag_Bytes0>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, nnt::capsrv::ArrayValue, &nnt::capsrv::MakerNoteInfo::bytes0, nn::capsrv::server::detail::MakerNoteValueClass_Bytes>
            , DefaultValueZeroClear<nnt::capsrv::MakerNoteVersion_Version0, nnt::capsrv::ArrayValue, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version0, 1, 1, void>
        {};

        struct Integer1Property
            : TagDefinition<MakerNoteEntryTag_Integer1>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer1, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer1Default, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version1, 1, 1, void>
        {};

        struct Bytes1Property
            : TagDefinition<MakerNoteEntryTag_Bytes1>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, nnt::capsrv::ArrayValue, &nnt::capsrv::MakerNoteInfo::bytes1, nn::capsrv::server::detail::MakerNoteValueClass_Bytes>
            , DefaultValueZeroClear<nnt::capsrv::MakerNoteVersion_Version0, nnt::capsrv::ArrayValue, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version1, 1, 1, void>
        {};

        struct Integer2ReqProperty
            : TagDefinition<MakerNoteEntryTag_Integer2Req>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer2req, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer2ReqDefault, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version2, 1, 1, void>
        {};

        struct Integer2OptProperty
            : TagDefinition<MakerNoteEntryTag_Integer2Opt>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer2opt, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer2OptDefault, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version2, 0, 1, void>
        {};

        struct Integer3ReqProperty
            : TagDefinition<MakerNoteEntryTag_Integer3Req>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer3req, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer3ReqDefault, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version3, 1, 1, void>
        {};

        struct Integer3OptProperty
            : TagDefinition<MakerNoteEntryTag_Integer3Opt>
            , ValueDefinition<nnt::capsrv::MakerNoteInfo, uint32_t, &nnt::capsrv::MakerNoteInfo::integer3opt, nn::capsrv::server::detail::MakerNoteValueClass_Integer>
            , DefaultValueInteger<nnt::capsrv::MakerNoteVersion_Version0, uint32_t, MakerNoteInfo::Integer3OptDefault, void>
            , EntryCountMinMaxFrom<nnt::capsrv::MakerNoteVersion_Version3, 0, 1, void>
        {};
    };

#define NN_CAPSRV_DETAIL_FOREACH_MAKERNOTEPROPERTY(macro)    \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer0Property) \
    macro(nnt::capsrv::MakerNoteValueProperty::Bytes0Property) \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer1Property) \
    macro(nnt::capsrv::MakerNoteValueProperty::Bytes1Property) \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer2ReqProperty) \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer2OptProperty) \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer3ReqProperty) \
    macro(nnt::capsrv::MakerNoteValueProperty::Integer3OptProperty) \
    //
}}

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    typedef nnt::capsrv::MakerNoteForFoundationTestTag MakerNoteTag;

    enum MakerNoteVersion
    {
        MakerNoteVersion_End = nnt::capsrv::MakerNoteVersion_End,
    };

    enum MakerNoteEntryTag
    {
        MakerNoteEntryTag_Max = nnt::capsrv::MakerNoteEntryTag_Max,
    };

}}}}

#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteEntryParser.impl.h"
#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteEntryDecoder.impl.h"
#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteEntryVisitor.impl.h"
#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteParser.impl.h"
#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/detail/capsrvServer_MakerNoteGenerator.impl.h"

namespace nnt{ namespace capsrv{

    nn::Result ParseMakerNoteForTestFoundation(
        MakerNoteInfo* pOutValue,
        const void* pMakerNoteData,
        size_t makerNoteDataSize
        ) NN_NOEXCEPT
    {
        return nn::capsrv::server::detail::MakerNoteParser<nnt::capsrv::MakerNoteInfo, MakerNoteForFoundationTestTag>::Parse(pOutValue, pMakerNoteData, makerNoteDataSize);
    }

    size_t GenerateMakerNoteForTestFoundation(
        void* buffer,
        size_t size,
        const MakerNoteInfo& info
        ) NN_NOEXCEPT
    {
        return nn::capsrv::server::detail::MakerNoteGenerator<MakerNoteInfo, MakerNoteForFoundationTestTag>::Generate(buffer, size, info);
    }

    int GetEntryMinCountForTestFoundataion(uint32_t version, uint16_t tag) NN_NOEXCEPT
    {
        switch(tag)
        {
        #define NNT_CAPSRV_CASE_PROPERTY(p)  \
        case p::EntryTag: return p::GetEntryCountMin(version);

            NN_CAPSRV_DETAIL_FOREACH_MAKERNOTEPROPERTY(NNT_CAPSRV_CASE_PROPERTY)

        #undef NNT_CAPSRV_CASE_PROPERTY
        default: return 0;
        }
    }

    int GetEntryMaxCountForTestFoundataion(uint32_t version, uint16_t tag) NN_NOEXCEPT
    {
        switch(tag)
        {
        #define NNT_CAPSRV_CASE_PROPERTY(p)  \
        case p::EntryTag: return p::GetEntryCountMax(version);

            NN_CAPSRV_DETAIL_FOREACH_MAKERNOTEPROPERTY(NNT_CAPSRV_CASE_PROPERTY)

        #undef NNT_CAPSRV_CASE_PROPERTY
        default: return 0;
        }
    }

}}
