﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

#include <nn/os.h>
#include <nn/init.h>
#include <nn/mem.h>
#include <nn/fs.h>
#include <nn/time/time_Api.h>
#include <nv/nv_MemoryManagement.h>
#include <nvnTool/nvnTool_GlslcInterface.h>

#include <nnt.h>

#include "../../Common/testCapsrv_AlignedAllocate.h"
#include "../../Common/testCapsrv_DirectAlbumAccessor.h"

// スレッド関数
void GfxThreadFunction(void*);
void CapsrvThreadFunction(void*);

// スレッド
static const size_t GfxThreadStackSize          = 1024 * 1024;
static const size_t CapsrvThreadStackSize       = 1024 * 1024;
static const int GfxThreadCoreId = 0;
static const int CapsrvThreadCoreId = 1;

std::atomic_int g_ScreenShotCount;
nn::os::EventType g_TestEndEvent;

TEST(TakeScreenShot, Self)
{
    nn::Result result;
    nn::time::Initialize();
    nn::os::InitializeEvent(&g_TestEndEvent, false, nn::os::EventClearMode_ManualClear);

    nnt::capsrv::DirectAlbumAccessor::CleanupAllAlbums();

    {
        nn::os::ThreadType gfxThread;
        nn::os::ThreadType capsrvThread;


        void* gfxThreadStack = nnt::capsrv::AlignedAllocate(nullptr, GfxThreadStackSize, nn::os::ThreadStackAlignment);
        void* capsrvThreadStack = nnt::capsrv::AlignedAllocate(nullptr, CapsrvThreadStackSize, nn::os::ThreadStackAlignment);
        NN_ASSERT_NOT_NULL(gfxThreadStack);
        NN_ASSERT_NOT_NULL(capsrvThreadStack);

        result = nn::os::CreateThread(
            &gfxThread,
            GfxThreadFunction,
            nullptr,
            gfxThreadStack,
            GfxThreadStackSize,
            nn::os::DefaultThreadPriority,
            GfxThreadCoreId
            );
        NN_ASSERT(result.IsSuccess());

        result = nn::os::CreateThread(
            &capsrvThread,
            CapsrvThreadFunction,
            nullptr,
            capsrvThreadStack,
            CapsrvThreadStackSize,
            nn::os::DefaultThreadPriority,
            CapsrvThreadCoreId
            );
        NN_ASSERT(result.IsSuccess());

        nn::os::StartThread(&gfxThread);
        nn::os::StartThread(&capsrvThread);

        nn::os::WaitThread(&gfxThread);
        nn::os::WaitThread(&capsrvThread);

        nn::os::DestroyThread(&gfxThread);
        nn::os::DestroyThread(&capsrvThread);
        free(gfxThreadStack);
        free(capsrvThreadStack);
    }
    //CapsrvThreadFunction(nullptr);
    //GfxThreadFunction(nullptr);

    nn::os::FinalizeEvent(&g_TestEndEvent);
    nn::time::Finalize();
    SUCCEED();
}
