﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_Optional.h>
#include <nn/gfx/util/gfx_MemoryPoolAllocator.h>
#include <nn/vi/vi_LayerStack.h>
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_MemoryPool.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_ImageBuffer.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_DisplayBuffer.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_DisplayCapture.h"

namespace nnt{ namespace capsrv{

    static const int DefaultWidth = 1280;
    static const int DefaultHeight = 720;
    static const char DefaultCaptureName[] = "testCapture";

    class CaptureMemoryPool
    {
    public:
        CaptureMemoryPool(void* pMemory, size_t size) NN_NOEXCEPT;
        ~CaptureMemoryPool() NN_NOEXCEPT;

        ptrdiff_t Allocate(size_t size, size_t alignment) NN_NOEXCEPT;
        void Free(ptrdiff_t offset) NN_NOEXCEPT;

        nn::capsrv::capture::MemoryPool* Get() NN_NOEXCEPT;
        nn::capsrv::capture::MemoryPool* operator->() NN_NOEXCEPT{ return Get(); }

    private:
        nn::capsrv::capture::MemoryPool m_MemoryPool;
        nn::gfx::util::MemoryPoolAllocator m_Allocator;
    };

    class CaptureImageBuffer
    {
    public:
        CaptureImageBuffer(int width, int height, nn::capsrv::capture::ImageFormat format, CaptureMemoryPool* pMemoryPool) NN_NOEXCEPT;
        ~CaptureImageBuffer() NN_NOEXCEPT;

        nn::capsrv::capture::ImageBuffer* Get() NN_NOEXCEPT;
        nn::capsrv::capture::ImageBuffer* operator->() NN_NOEXCEPT{ return Get(); }

    private:
        nn::capsrv::capture::ImageBuffer m_ImageBuffer;
        ptrdiff_t m_Offset;
        CaptureMemoryPool* m_pMemoryPool;
    };

    class CaptureDisplayBuffer
    {
    public:
        CaptureDisplayBuffer(int width, int height, nn::capsrv::capture::ImageFormat format, CaptureMemoryPool* pMemoryPool) NN_NOEXCEPT;
        ~CaptureDisplayBuffer() NN_NOEXCEPT;

        nn::capsrv::capture::DisplayBuffer* Get() NN_NOEXCEPT;
        nn::capsrv::capture::DisplayBuffer* operator->() NN_NOEXCEPT{ return Get(); }

    private:
        nn::capsrv::capture::DisplayBuffer m_DisplayBuffer;
        nn::util::optional<CaptureImageBuffer> m_ImageBufferList[3];
        int m_ImageBufferCount;
    };

    class CaptureDisplayCapture
    {
    public:
        CaptureDisplayCapture(int width, int height, nn::capsrv::capture::ImageFormat format, nn::vi::LayerStack layerStack) NN_NOEXCEPT;
        ~CaptureDisplayCapture() NN_NOEXCEPT;

        nn::capsrv::capture::DisplayCapture* Get() NN_NOEXCEPT;
        nn::capsrv::capture::DisplayCapture* operator->() NN_NOEXCEPT{ return Get(); }

    private:
        nn::capsrv::capture::DisplayCapture m_DisplayCapture;
    };

}}

