﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/mem/mem_StandardAllocator.h>

#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_CaptureModule.h"
#include "../../../../../Programs/Iris/Sources/Libraries/capsrv/capture/capsrv_MemoryPool.h"

#include "testCapsrv_Static.h"

static const int RepeatCount = 1000;

TEST(MemoryPool, InitializeFinalize)
{

    nn::capsrv::capture::InitializeCaptureModule();
    auto pModule = nn::capsrv::capture::GetCaptureModule();

    auto f = [&](){
        nn::capsrv::capture::MemoryPool pool;
        NN_ABORT_UNLESS_RESULT_SUCCESS(pool.Initialize(pModule, g_Storage, sizeof(g_Storage)));
        pool.Finalize();
    };

    NN_LOG("first initializing-finalizing\n");
    f();
    size_t freeMemoryAfterFirst = g_GraphicsAllocator.GetTotalFreeSize();

    NN_LOG("repeat initializing-finalizing\n");
    for(int i = 0; i < RepeatCount; i++)
    {
        if(i % 100 == 0)
        {
            NN_LOG("  %d-th loop\n", i);
        }
        f();
    }

    size_t freeMemoryAfterRepeat = g_GraphicsAllocator.GetTotalFreeSize();

    NN_LOG("free memory:\n  after first %llu\n  after repeat %llu\n", freeMemoryAfterFirst, freeMemoryAfterRepeat);
    // 多分同じになる
    EXPECT_EQ(freeMemoryAfterFirst, freeMemoryAfterRepeat);

    nn::capsrv::capture::FinalizeCaptureModule();

}
