﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include <nnt.h>

#include <nn/capsrv/capsrv_AlbumAccess.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include <nn/capsrv/capsrv_AlbumTesting.h>
#include "../../Common/testCapsrv_Macro.h"
#include "../../Common/testCapsrv_DirectAlbumAccessor.h"
#include "../../Common/testCapsrv_FileInfo.h"
#include "../../Common/testCapsrv_AlbumEntryUtility.h"
#include "testCapsrv_StartupTestCase.h"

static int RepeatCount = 100;

TEST(AlbumAccessApi, ControlSession_OpenClose)
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::InitializeAlbumControl());

    for(int i = 0; i < RepeatCount; i++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::OpenAlbumControlSession());
        nn::capsrv::CloseAlbumControlSession();
    }

    nn::capsrv::FinalizeAlbumControl();
}

TEST(AlbumAccessApi, ControlSession_OpenFinalize)
{
    for(int i = 0; i < RepeatCount; i++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::InitializeAlbumControl());
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::OpenAlbumControlSession());
        //nn::capsrv::CloseAlbumControlSession();
        nn::capsrv::FinalizeAlbumControl();
    }
}

TEST(AlbumAccessApi, ControlSession_OpenExFinalize)
{
    for(int i = 0; i < RepeatCount; i++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::InitializeAlbumControl());
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::InitializeAlbumControlExtension());
        nn::capsrv::FinalizeAlbumControl();
    }
}
