﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testCapsrv_StartupTestCase.h"

#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/capsrv/capsrv_AlbumTesting.h>
#include "../../Common/testCapsrv_Macro.h"
#include "../../Common/testCapsrv_DirectAlbumAccessor.h"

namespace nnt{ namespace capsrv{

    void StartupTestCase() NN_NOEXCEPT
    {
        NN_LOG("StartingupTestCase ...\n");
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::capsrv::InitializeAlbumAccess());

        // マウント状態をリセット
        NNT_CAPSRV_FOREACH_STORAGE(storage)
        {
            nn::capsrv::ResetAlbumMountStatus(storage);
        }

        // Result 値の変換をリセット
        nn::capsrv::SetInternalConversionEnabled(true);

        nn::capsrv::FinalizeAlbumAccess();
        NN_LOG("StartingupTestCase ... complete\n");
    }

}}

