﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <random>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/movie/capsrv_MovieMetaDataBuilder.h>
#include "../../../Programs/Iris/Sources/Libraries/capsrv/server/capsrvServer_Config.h"
#include "testCapsrv_ScreenShotFileCreator.h"

namespace nnt{ namespace capsrv{

    struct MovieData
    {
        std::vector<uint8_t> value;
    };

    struct MovieMeta
    {
    public:
        enum Flag
        {
            Flag_None = 0,
            Flag_ZeroSignature = (1 << 0),
        };

    public:
        std::vector<uint8_t> value;
        nn::capsrv::movie::MovieMetaData* pMeta;
        uint64_t makerNoteVersion;
        int64_t makerNoteOffset;
        int64_t makerNoteSize;
    };

    struct MovieDataHash
    {
        std::vector<uint8_t> value;
    };

    struct MovieMetaHash
    {
        std::vector<uint8_t> value;
    };

    struct MovieSignature
    {
        uint8_t value[nn::capsrv::server::MovieSignatureSize];
    };

    struct MovieVersion
    {
        uint64_t value;
    };

    class MovieFileCreator
    {
    public:
        static MovieData CreateRandomMovieData(
            size_t movieDataSize,
            std::mt19937& rand
        ) NN_NOEXCEPT;

        static ScreenShotMetaInfo CreateScreenShotMetaDefault(
            const nn::capsrv::AlbumFileId& fileId
        ) NN_NOEXCEPT;

        static MovieMeta CreateMetaWithRandomImageData(
            const nn::capsrv::AlbumFileId& fileId,
            size_t movieDataSize,
            std::mt19937& rand,
            MovieMeta::Flag flags = MovieMeta::Flag_None
        ) NN_NOEXCEPT;

        static void SetValidMetaSignature(
            MovieMeta& meta
        ) NN_NOEXCEPT;

        static MovieDataHash CreateValidMovieDataHash(
            const MovieData& movieData
        ) NN_NOEXCEPT;

        static MovieMetaHash CreateValidMovieMetaHash(
            const MovieMeta& movieMeta
        ) NN_NOEXCEPT;

        static MovieSignature CreateValidMovieSignature(
            const MovieDataHash& movieDataHash,
            const MovieMetaHash& movieMetaHash
        ) NN_NOEXCEPT;

        static MovieVersion CreateValidMovieVersion(
            uint64_t version
        ) NN_NOEXCEPT;

        // @param nn::Result (*outputFunc)(int64_t offset, const void* buffer, size_t size)
        template<typename OutputFunction>
        static nn::Result WriteFileData(
            OutputFunction outputFunc,
            const MovieData& movieData,
            const MovieMeta& movieMeta,
            const MovieDataHash& dataHash,
            const MovieMetaHash& metaHash,
            const MovieSignature& signature,
            const MovieVersion& version
        ) NN_NOEXCEPT
        {
            int64_t offset = 0;

            NN_RESULT_DO(outputFunc(offset, movieData.value.data(), movieData.value.size()));
            offset += movieData.value.size();

            NN_RESULT_DO(outputFunc(offset, movieMeta.value.data(), movieMeta.value.size()));
            offset += movieMeta.value.size();

            NN_RESULT_DO(outputFunc(offset, dataHash.value.data(), dataHash.value.size()));
            offset += dataHash.value.size();

            NN_RESULT_DO(outputFunc(offset, metaHash.value.data(), metaHash.value.size()));
            offset += metaHash.value.size();

            NN_RESULT_DO(outputFunc(offset, signature.value, sizeof(signature.value)));
            offset += sizeof(signature.value);

            NN_RESULT_DO(outputFunc(offset, &version.value, sizeof(version.value)));
            offset += sizeof(version.value);

            NN_RESULT_SUCCESS;
        }

    };

}}
