﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testCapsrv_AlignedAllocate.h"

#include <cstdlib>

namespace nnt{ namespace capsrv{

        void* AlignedAllocate(nn::mem::StandardAllocator* pAllocator, size_t size, size_t alignment) NN_NOEXCEPT
        {
            if(pAllocator)
            {
                return pAllocator->Allocate(size, alignment);
            }
            else
            {
#ifdef _WIN32
                return _aligned_malloc(size, alignment);
#else
                return aligned_alloc(alignment, size);
#endif
            }
        }

        void AlignedFree(nn::mem::StandardAllocator* pAllocator, void* ptr) NN_NOEXCEPT
        {
            if(pAllocator)
            {
                pAllocator->Free(ptr);
            }
            else
            {
#ifdef _WIN32
                _aligned_free(ptr);
#else
                free(ptr);
#endif
            }
        }
}}
