﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <nn/capsrv/capsrv_AlbumEntry.h>

namespace nnt{ namespace capsrv{

    struct AlbumEntryListDifference
    {
        // 引き算した左辺にしか存在しなかったエントリーです。
        std::vector<nn::capsrv::AlbumEntry> positive;
        // 引き算した右辺にしか存在しなかったエントリーです。
        std::vector<nn::capsrv::AlbumEntry> negative;
    };

    // @brief 時刻の比較を行います。
    int CompareTime(const nn::capsrv::AlbumFileDateTime& lhs, const nn::capsrv::AlbumFileDateTime& rhs);

    // @brief ストレージと時刻を比較します。
    int CompareAlbumEntryStorageTime(const nn::capsrv::AlbumEntry& lhs, const nn::capsrv::AlbumEntry& rhs);

    // @brief ファイルリストを取得します
    // @details
    // マウントされていない場合空のリストを返します。
    std::vector<nn::capsrv::AlbumEntry> GetAlbumEntryList(nn::capsrv::AlbumStorageType storage);

    // @brief ソートします
    void SortAlbumEntryListStorageTime(std::vector<nn::capsrv::AlbumEntry>& list);

    // @brief 引き算を行います。
    // @pre 両辺のリストはソート済である必要があります。
    void SubtractAlbumEntryList(AlbumEntryListDifference* pOutValue, const std::vector<nn::capsrv::AlbumEntry>& lhs, const std::vector<nn::capsrv::AlbumEntry>& rhs);

}}
