﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>

namespace nnt { namespace btm {

class Pad
{
private:
    static const int NpadIdCountMax = 2;

    nn::hid::NpadFullKeyState m_NpadFullKeyState;

    nn::hid::NpadHandheldState m_NpadHandheldState;

    nn::hid::NpadJoyDualState m_NpadJoyDualState;

public:
    Pad() NN_NOEXCEPT;

    void Initialize() NN_NOEXCEPT;

    nn::hid::NpadButtonSet Update() NN_NOEXCEPT;
};

}}
