﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/oe.h>

#include <nn/btm/system/btm_SystemApi.h>
#include <nn/btm/system/btm_SystemResult.h>

nn::os::SystemEventType g_SystemEventForRadio;
nn::os::SystemEventType g_SystemEventForGpp;


void Initialize()
{
    NN_LOG("[TestBtm_SystemO]%s\n",__FUNCTION__);
    nn::btm::system::AcquireRadioEvent(&g_SystemEventForRadio);
    nn::btm::system::AcquireGamepadPairingEvent(&g_SystemEventForGpp);
    NN_LOG("[TestBtm_SystemO]%s\n\n",__FUNCTION__);
}

extern "C" void nnMain()
{
    NN_LOG("[TestBtm_SystemO]%s\n",__FUNCTION__);
    Initialize();
    nn::os::ClearSystemEvent(&g_SystemEventForGpp);
    nn::os::WaitSystemEvent(&g_SystemEventForGpp);
    NN_LOG("[TestBtm_SystemO]%s\n\n",__FUNCTION__);
}
