﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_Thread.h>
#include <nn/nn_TimeSpan.h>

#include <nn/btm/btm.h>
#include <nn/btm/btm_Result.h>
#include <nn/btm/debug/btm_DebugApi.h>

extern "C" void nnMain()
{
    NN_LOG("[TestBtm_Recovery]InitializeBtmDebugInterface\n");
    nn::btm::debug::InitializeBtmDebugInterface();

    nn::btm::debug::GeneralTest(9);
    NN_LOG("[TestBtm_Recovery]Recovery queued via API handler.\n");

    NN_LOG("[TestBtm_Recovery]FinalizeBtmDebugInterface.\n");
    nn::btm::debug::FinalizeBtmDebugInterface();
    NN_LOG("[TestBtm_Recovery]TestApp end.\n");
}
