﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/oe.h>
#include <nn/oe/oe_PowerStateControlApi.private.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/bluetooth/bluetooth_Api.h>

//同期型でフラグ書き込み
void WriteFlag(const bool isSkipBoot)
{
    nn::settings::fwdbg::SetSettingsItemValue("bluetooth_debug", "skip_boot", &isSkipBoot, sizeof(isSkipBoot));

    //書き込みを確実にするために再読み込み
    bool isSbfOut;
    nn::settings::fwdbg::GetSettingsItemValue(&isSbfOut, sizeof(isSbfOut), "bluetooth_debug", "skip_boot");

    if(isSkipBoot != isSbfOut)
    {
        NN_ABORT("[testBtm_ProductionProcess]Faulty design\n");
    }
}

void InitializeBluetooth()
{
    nn::bluetooth::InitializeBluetoothDriver();

    nn::Result result;
    nn::os::SystemEventType dummyEvent;
    result = nn::bluetooth::InitializeBluetooth(&dummyEvent);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::bluetooth::EnableBluetooth();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void FinalizeBluetooth()
{
    nn::Result result;
    result = nn::bluetooth::DisableBluetooth();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nn::bluetooth::CleanupBluetooth();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    nn::bluetooth::FinalizeBluetoothDriver();
}

extern "C" void nnMain()
{
    NN_LOG("[testBtm_ProductionProcess]Start.\n");

    bool isSkipBoot;
    nn::settings::fwdbg::GetSettingsItemValue(&isSkipBoot, sizeof(isSkipBoot), "bluetooth_debug", "skip_boot");

    if(isSkipBoot)
    {
        NN_LOG("[testBtm_ProductionProcess]Suitable precondition. Shutdown will be triggered after 10 seconds.\n");
        WriteFlag(false);//フラグを正常状態に戻す
        InitializeBluetooth();
        for(int i=0;i<10;i++)
        {
            NN_LOG("%d\n", i);
            ::nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
        }
        FinalizeBluetooth();
        nn::oe::RequestToShutdown();
    }
    else
    {
        //スキップフラグが立っていないので、フラグを立てて再起動後の再テストを促す
        WriteFlag(true);
        NN_LOG("[testBtm_ProductionProcess]Writing Skip flag done. Needs reboot and re-test.\n");
    }
}
