﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_EventTypes.h>

#include "testBtmModule_TestBase.h"

namespace BtmUsecase
{
    class TestBtmModule_Usecase : public TestBtmModule_TestBase
    {
    public:
        //!< ConnectedDeviceConditionEvent を処理する
        virtual void HandleConnectedDeviceConditionEvent() { TestBtmModule_TestBase::HandleConnectedDeviceConditionEvent(); }

        //!< RegisterDeviceInfoEvent を処理する
        virtual void HandleRegisterDeviceInfoEvent() { TestBtmModule_TestBase::HandleRegisterDeviceInfoEvent(); }

        //!< LlrStateEvent を処理する
        virtual void HandleLlrStateEvent() { TestBtmModule_TestBase::HandleLlrStateEvent(); }

        //!< RadioEvent を処理する
        virtual void HandleRadioEvent() { TestBtmModule_TestBase::HandleRadioEvent(); }

        //!< GamepadPairingEvent を処理する
        virtual void HandleGamepadPairingEvent() { TestBtmModule_TestBase::HandleGamepadPairingEvent(); }

        //!< BleScanEvent を処理する
        virtual void HandleBleScanEvent() { TestBtmModule_TestBase::HandleBleScanEvent(); }

        //!< BleConnectionEvent を処理する
        virtual void HandleBleConnectionEvent() { TestBtmModule_TestBase::HandleBleConnectionEvent(); }

        //!< BlePairingEvent を処理する
        virtual void HandleBlePairingEvent() { HandleUnexpectedEvent(); }

        //!< BleServiceDiscoveryEvent を処理する
        virtual void HandleBleServiceDiscoveryEvent() { TestBtmModule_TestBase::HandleBleServiceDiscoveryEvent(); }

        //!< BleMtuConfigEvent を処理する
        virtual void HandleBleMtuConfigEvent() { TestBtmModule_TestBase::HandleBleMtuConfigEvent(); }

        //!< InternalUsecase_Dynamic2Slot2 におけるユースケースをテストします
        void TestDynamic2Slot2();

        //!< InternalUsecase_Dynamic2Slot6 におけるユースケースをテストします
        void TestDynamic2Slot6();

        //!< InternalUsecase_Dynamic2Slot8 におけるユースケースをテストします
        void TestDynamic2Slot8();

        //!< InternalUsecase_StaticJoy4 におけるユースケースをテストします
        void TestStaticJoy4();

        //!< InternalUsecase_StaticJoy8 におけるユースケースをテストします
        void TestStaticJoy8();

        //!< InternalUsecase_Active におけるユースケースをテストします
        void TestActive();

        //!< InternalUsecase_Local8StaticJoy2 におけるユースケースをテストします
        void TestStaticJoy2Local8();

        //!< InternalUsecase_Local4StaticJoy4 におけるユースケースをテストします
        void TestStaticJoy4Local4();

        //!< InternalUsecase_Ble1 におけるユースケースをテストします
        void TestBle1();

        //!< InternalUsecase_Ble2 におけるユースケースをテストします
        void TestBle2();

        //!< InternalUsecase_Ble3 におけるユースケースをテストします
        void TestBle3();

        //!< BTM の各パラメータにおけるユースケースの有効・無効をデバッグ出力します
        void TestPrintAllUsecase();

    private:
        //!< すべての接続を切断、ペアリング情報を削除し、Bluetooth Mode, Wlan Mode, Slot Saving をリセットします
        void SetPlain();

        //!< 指定した接続数で、InternalUsecase_Dynamic2Slot2 な状態にします
        void SetToDynamic2Slot2(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Dynamic2Slot6 な状態にします
        void SetToDynamic2Slot6(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Dynamic2Slot8 な状態にします
        void SetToDynamic2Slot8(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_StaticJoy4 な状態にします
        void SetToStaticJoy4(uint8_t deviceCount, uint8_t largeSlotDeviceCount);

        //!< 指定した接続数で、InternalUsecase_StaticJoy8 な状態にします
        void SetToStaticJoy8(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Active な状態にします
        void SetToActive(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Local8StaticJoy2 な状態にします
        void SetToStaticJoy2Local8(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Local4StaticJoy4 な状態にします
        void SetToStaticJoy4Local4(uint8_t deviceCount);

        //!< 指定した接続数で、InternalUsecase_Local4StaticJoy2Ble"N" な状態にします
        void SetToStaticJoy2Local4BleN(uint8_t brEdrDeviceCount, uint8_t bleDeviceCount);

        //!< Bluetooth Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetBluetoothMode(nn::btm::BluetoothMode bluetoothMode);

        //!< Wlan Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetWlanMode(nn::btm::WlanMode wlanMode);

        //!< Slot Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetSlotMode(const nn::btm::DeviceSlotModeList& slotModeList);

        //!< 指定のScan Filter を使って、BLE デバイスを対象としたBLE Scan の開始を試行します。BLE Scan が開始されたかどうかは判断しません。
        nn::Result TryStartBleScanGeneral(const nn::btm::user::BleAdvFilterForGeneral& filter);

        //!< BLE デバイスを対象としたBLE Scan の停止を試行します。BLE Scan が停止したかどうかは判断しません。
        nn::Result TryStopBleScanGeneral();
    };
}   // namespace BtmUsecase

