﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_EventTypes.h>

#include <nn/btm/user/btm_UserTypes.h>

#include "testBtmModule_TestBase.h"

namespace ApiBtmUser
{
    class TestBtmModule_ApiBtmUser : public TestBtmModule_TestBase
    {
    public:
        //!< ConnectedDeviceConditionEvent を処理する
        virtual void HandleConnectedDeviceConditionEvent() { TestBtmModule_TestBase::HandleConnectedDeviceConditionEvent(); }

        //!< RegisterDeviceInfoEvent を処理する
        virtual void HandleRegisterDeviceInfoEvent() { TestBtmModule_TestBase::HandleRegisterDeviceInfoEvent(); }

        //!< LlrStateEvent を処理する
        virtual void HandleLlrStateEvent() { HandleUnexpectedEvent(); }

        //!< RadioEvent を処理する
        virtual void HandleRadioEvent() { TestBtmModule_TestBase::HandleRadioEvent(); }

        //!< GamepadPairingEvent を処理する
        virtual void HandleGamepadPairingEvent() { TestBtmModule_TestBase::HandleGamepadPairingEvent(); }

        //!< BleScanEvent を処理する
        virtual void HandleBleScanEvent() { TestBtmModule_TestBase::HandleBleScanEvent(); }

        //!< BleConnectionEvent を処理する
        virtual void HandleBleConnectionEvent() { TestBtmModule_TestBase::HandleBleConnectionEvent(); }

        //!< BlePairingEvent を処理する
        virtual void HandleBlePairingEvent() { TestBtmModule_TestBase::HandleBlePairingEvent(); }

        //!< BleServiceDiscoveryEvent を処理する
        virtual void HandleBleServiceDiscoveryEvent() { TestBtmModule_TestBase::HandleBleServiceDiscoveryEvent(); }

        //!< BleMtuConfigEvent を処理する
        virtual void HandleBleMtuConfigEvent() { TestBtmModule_TestBase::HandleBleMtuConfigEvent(); }

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::GetBleScanFilterParameter()
         * - nn::btm::user::StartBleScanForGeneral()
         * - nn::btm::user::StopBleScanForGeneral()
         * - nn::btm::user::GetBleScanResultsForGeneral()
         * - nn::btm::user::StartBleScanForSmartDevice()
         * - nn::btm::user::StopBleScanForSmartDevice()
         * - nn::btm::user::GetBleScanResultsForSmartDevice()
         * - nn::btm::user::StartBleScanForPaired()
         * - nn::btm::user::StopBleScanForPaired()
         */
        void TestBleScan();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::BleConnect()
         * - nn::btm::user::BleDisconnect()
         * - nn::btm::user::BleGetConnectionState()
         */
        void TestBleConnect();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::GetGattServices()
         * - nn::btm::user::GetGattIncludedServices()
         * - nn::btm::user::GetGattService()
         * - nn::btm::user::GetBelongingGattService()
         * - nn::btm::user::GetGattCharacteristics()
         * - nn::btm::user::GetGattDescriptors()
         */
        void TestBleServiceDiscovery();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::BlePairDevice()
         * - nn::btm::user::BleUnPairDevice()
         * - nn::btm::user::BleGetPairedDevices()
         */
        void TestBlePairing();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::ConfigureBleMtu()
         * - nn::btm::user::GetBleMtu()
         */
        void TestBleMtuConfig();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::user::RegisterBleGattDataPath()
         * - nn::btm::user::UnregisterBleGattDataPath()
         */
        void TestBleDataPath();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::GetBleScanFilterParameter()
         * - nn::btm::user::StartBleScanForGeneral()
         * - nn::btm::user::StopBleScanForGeneral()
         * - nn::btm::user::GetBleScanResultsForGeneral()
         * - nn::btm::user::StartBleScanForSmartDevice()
         * - nn::btm::user::StopBleScanForSmartDevice()
         * - nn::btm::user::GetBleScanResultsForSmartDevice()
         * - nn::btm::user::StartBleScanForPaired()
         * - nn::btm::user::StopBleScanForPaired()
         */
        void TestBleScanRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::BleConnect()
         * - nn::btm::user::BleDisconnect()
         * - nn::btm::user::BleGetConnectionState()
         */
        void TestBleConnectRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::GetGattServices()
         * - nn::btm::user::GetGattIncludedServices()
         * - nn::btm::user::GetGattService()
         * - nn::btm::user::GetBelongingGattService()
         * - nn::btm::user::GetGattCharacteristics()
         * - nn::btm::user::GetGattDescriptors()
         */
        void TestBleServiceDiscoveryRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::BlePairDevice()
         * - nn::btm::user::BleUnPairDevice()
         * - nn::btm::user::BleGetPairedDevices()
         */
        void TestBlePairingRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::ConfigureBleMtu()
         * - nn::btm::user::GetBleMtu()
         */
        void TestBleMtuConfigRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::user::RegisterBleGattDataPath()
         * - nn::btm::user::UnregisterBleGattDataPath()
         */
        void TestBleDataPathRadioOff();

    private:
        //!< 指定のScan Filter を使って、BLE デバイスを対象としたBLE Scan の開始を試行します。BLE Scan が開始されたかどうかは判断しません。
        nn::Result TryStartBleScanGeneral(const nn::btm::user::BleAdvFilterForGeneral& filter);

        //!< BLE デバイスを対象としたBLE Scan の停止を試行します。BLE Scan が停止したかどうかは判断しません。
        nn::Result TryStopBleScanGeneral();

        //!< 指定のScan Filter を使って、スマートデバイスアプリケーションを対象としたBLE Scan の開始を試行します。BLE Scan が開始されたかどうかは判断しません。
        nn::Result TryStartBleScanSmartDevice(const nn::btm::user::BleAdvFilterForSmartDevice& filter);

        //!< スマートデバイスアプリケーションを対象としたBLE Scan の停止を試行します。BLE Scan が停止したかどうかは判断しません。
        nn::Result TryStopBleScanSmartDevicel();

        //!< 指定のScan Filter を使って、ペアリング済みのBLE デバイスを対象としたBLE Scan の開始を試行します。BLE Scan が開始されたかどうかは判断しません。
        nn::Result TryStartBleScanPaired(const nn::btm::user::BleAdvFilterForGeneral& filter);

        //!< ペアリング済みのBLE デバイスを対象としたBLE Scan の停止を試行します。BLE Scan が停止したかどうかは判断しません。
        nn::Result TryStopBleScanPaired();

        //!< 指定のConnection Handle を持つデバイスに対し、MTU の設定を試行します。MTU の設定が開始したかどうかは判断しません。
        nn::Result TryConfigureBleMtu(uint32_t connectionHandle, uint16_t mtu);

        //!< 指定のUUID を持つService のデータパスの登録／登録削除を試行します。処理が成功したかどうかの判断はしません。
        nn::Result TryRegisterGattDataPath(const nn::bluetooth::GattAttributeUuid& uuid, bool isToRegister);

    };
}   // namespace ApiBtmUser

