﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_EventTypes.h>

#include "testBtmModule_TestBase.h"

namespace ApiBtmSystem
{
    class TestBtmModule_ApiBtmSystem : public TestBtmModule_TestBase
    {
    public:
        //!< ConnectedDeviceConditionEvent を処理する
        virtual void HandleConnectedDeviceConditionEvent() { TestBtmModule_TestBase::HandleConnectedDeviceConditionEvent(); }

        //!< RegisterDeviceInfoEvent を処理する
        virtual void HandleRegisterDeviceInfoEvent() { TestBtmModule_TestBase::HandleRegisterDeviceInfoEvent(); }

        //!< LlrStateEvent を処理する
        virtual void HandleLlrStateEvent() { HandleUnexpectedEvent(); }

        //!< RadioEvent を処理する
        virtual void HandleRadioEvent() { TestBtmModule_TestBase::HandleRadioEvent(); }

        //!< GamepadPairingEvent を処理する
        virtual void HandleGamepadPairingEvent() { TestBtmModule_TestBase::HandleGamepadPairingEvent(); }

        //!< BleScanEvent を処理する
        virtual void HandleBleScanEvent() { HandleUnexpectedEvent(); }

        //!< BleConnectionEvent を処理する
        virtual void HandleBleConnectionEvent() { HandleUnexpectedEvent(); }

        //!< BlePairingEvent を処理する
        virtual void HandleBlePairingEvent() { TestBtmModule_TestBase::HandleBlePairingEvent(); }

        //!< BleServiceDiscoveryEvent を処理する
        virtual void HandleBleServiceDiscoveryEvent() { HandleUnexpectedEvent(); }

        //!< BleMtuConfigEvent を処理する
        virtual void HandleBleMtuConfigEvent() { HandleUnexpectedEvent(); }

        /**
         * 以下のAPI をテストします。
         * - nn::btm::system::StartGamepadPairing()
         * - nn::btm::system::CancelGameparPairing()
         * - nn::btm::system::IsGamepadPairingStarted()
         * - nn::btm::system::GetPairedGamepadCount()
         * - nn::btm::system::ClearGamepadPairingDatabase()
         */
        void TestGamepadPairing();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::system::EnableRadio()
         * - nn::btm::system::IsRadioEnabled()
         */
        void TestRadio();

        /**
         *  Radio OFF における、以下のAPI をテストします。
         * - nn::btm::system::StartGamepadPairing()
         * - nn::btm::system::CancelGameparPairing()
         * - nn::btm::system::IsGamepadPairingStarted()
         * - nn::btm::system::GetPairedGamepadCount()
         * - nn::btm::system::ClearGamepadPairingDatabase()
         */
        void TestGamepadPairingRadioOff();
    };
}   // namespace ApiBtmSystem

