﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_EventTypes.h>

#include "testBtmModule_TestBase.h"

namespace ApiBtm
{
    class TestBtmModule_ApiBtm : public TestBtmModule_TestBase
    {
    public:
        //!< ConnectedDeviceConditionEvent を処理する
        virtual void HandleConnectedDeviceConditionEvent() { TestBtmModule_TestBase::HandleConnectedDeviceConditionEvent(); }

        //!< RegisterDeviceInfoEvent を処理する
        virtual void HandleRegisterDeviceInfoEvent() { TestBtmModule_TestBase::HandleRegisterDeviceInfoEvent(); }

        //!< LlrStateEvent を処理する
        virtual void HandleLlrStateEvent() { TestBtmModule_TestBase::HandleLlrStateEvent(); }

        //!< RadioEvent を処理する
        virtual void HandleRadioEvent() { TestBtmModule_TestBase::HandleRadioEvent(); }

        //!< GamepadPairingEvent を処理する
        virtual void HandleGamepadPairingEvent() { TestBtmModule_TestBase::HandleGamepadPairingEvent(); }

        //!< BleScanEvent を処理する
        virtual void HandleBleScanEvent() { HandleUnexpectedEvent(); }

        //!< BleConnectionEvent を処理する
        virtual void HandleBleConnectionEvent() { HandleUnexpectedEvent(); }

        //!< BlePairingEvent を処理する
        virtual void HandleBlePairingEvent() { HandleUnexpectedEvent(); }

        //!< BleServiceDiscoveryEvent を処理する
        virtual void HandleBleServiceDiscoveryEvent() { HandleUnexpectedEvent(); }

        //!< BleMtuConfigEvent を処理する
        virtual void HandleBleMtuConfigEvent() { HandleUnexpectedEvent(); }

       /**
         * 以下のAPI をテストします。
         * - nn::btm::InitializeBtmInterface()
         * - nn::btm::FinalizeBtmInterface()
         */
        void TestInterface();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::GetState()
         */
        void TestBtmState(nn::btm::BtmState expectedState) const;

        /**
         * 以下のAPI をテストします。
         * - nn::btm::GetHostDeviceProperty()
         */
        void TestHostDeviceProperty(const char* pHostName, size_t hostNameSize, const nn::btm::ClassOfDevice classOfDevice, uint8_t featureSet);

        /**
         * 以下のAPI をテストします。
         * - nn::btm::AddDeviceInfo()
         * - nn::btm::RemoveDeviceInfo()
         * - nn::btm::IncreaseDeviceInfoOrder()
         * - nn::btm::ProtectDeviceInfo()
         */
        void TestDeviceInfo();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::SetBluetoothMode()
         * - nn::btm::SetWlanMode()
         * - nn::btm::SetSlotMode()
         * - nn::btm::HidSetRetransmissionMode()
         */
        void TestMode();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::EnableSlotSaving()
         */
        void TestEnableSlotSaving();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::EnableRadio()
         */
        void TestEnableRadio();

        /**
         * 以下のAPI をテストします。
         * - nn::btm::LlrNotify()
         */
        void TestLlrNotify();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::GetState()
         */
        void TestBtmStateRadioOff(nn::btm::BtmState expectedState);

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::GetHostDeviceProperty()
         */
        void TestHostDevicePropertyRadioOff(const char* pHostName, size_t hostNameSize, const nn::btm::ClassOfDevice classOfDevice, uint8_t featureSet);

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::AddDeviceInfo()
         * - nn::btm::RemoveDeviceInfo()
         * - nn::btm::IncreaseDeviceInfoOrder()
         * - nn::btm::ProtectDeviceInfo()
         */
        void TestDeviceInfoRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::SetBluetoothMode()
         * - nn::btm::SetWlanMode()
         * - nn::btm::SetSlotMode()
         * - nn::btm::HidSetRetransmissionMode()
         */
        void TestModeRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::EnableSlotSaving()
         */
        void TestEnableSlotSavingRadioOff();

        /**
         * Radio OFF における、以下のAPI をテストします。
         * - nn::btm::LlrNotify()
         */
        void TestLlrNotifyRadioOff();

    private:
        //!< 指定のBluetooth アドレスを持つデバイスに向けてLLR を試行します。LLR が開始されたかどうかは判断しません。
        nn::Result TryLlr(const nn::btm::BdAddress& address);

        //!< Bluetooth Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetBluetoothMode(nn::btm::BluetoothMode bluetoothMode);

        //!< Wlan Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetWlanMode(nn::btm::WlanMode wlanMode);

        //!< Slot Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetSlotMode(const nn::btm::DeviceSlotModeList& slotModeList);

        //!< 指定のBluetooth アドレスを持つデバイスのZero Retransmission Mode の設定を試行します。設定が開始されたかどうかは判断しません。
        nn::Result TrySetRetransmissionMode(const nn::btm::BdAddress& address, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList);
    };
}   // namespace ApiBtm

