﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/system/hid_Nfc.h>

namespace nnt { namespace btm {
enum HidButton
{
    HidButton_A,
    HidButton_R,
    HidButton_L,
    HidButton_Up,
    HidButton_Down,
    HidButton_Left,
    HidButton_Right,
    HidButton_ZR_A,
    HidButton_ZR_B,
    HidButton_ZR_X,
    HidButton_ZR_Y,
    HidButton_ZL_A,
    HidButton_ZL_B,
    HidButton_ZL_X,
    HidButton_ZL_Y,
    HidButton_None,
};

struct HidInput
{
    bool isUpdated;
    nn::hid::NpadIdType npadIdType;
    HidButton hidButton;
    nn::hid::NpadJoyDualState joyDualState;
    nn::hid::NpadHandheldState handheldState;
};

void HidInit();
HidInput HidUpdateDummy();
HidInput HidUpdate();

nn::Result StartNfpScan(nn::hid::NpadIdType usingPad);
nn::Result StopNfpScan(nn::hid::NpadIdType usingPad);
}}
