﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/nn_Common.h>

#include "testBpc_ExpectedEntry.h"

namespace nnt { namespace bpc {

const std::vector<ExpectedEntry> Max77621GpuExpectedEntries =
{
    // ===== 割込み =====

    /**
     * VOUT
     * [7]  EN       : 0b1
     * [6:0]VOUT
     *
     * CI 上では GPU 電源が投入されていない事があり得るのでチェックしない。
     */
    { 0x00, 0xbf, 0x00 },

    /**
     * VOUT_DVS
     * [6:0]VOUT_DVS
     */
    { 0x01, 0xa1, 0x00 },

    /**
     * CONTROL1
     * [7]  SNS_EN   : 0b1 (Remote Sense: Enabled)
     * [6]  FPWM_EN  : 0b0 (Forced PWM Mode: Disabled)
     * [5]  nFSR_EN  : 0b1 (Active-Low Falling Slew Rate: Disabled)
     * [4]  AD_EN    : 0b1 (Output Active Discharge: Enabled)
     * [3]  BIASEN   : 0b0 (Startup delay is 240 us(typ))
     * [2]  FREQSHIFT: 0b0 (Frequency Shift: 2 MHz(typ))
     * [1:0]RAMP     : 0b00 (Slew Rate: 12.5 mV/us)
     */
    { 0x02, 0xb0, 0xff },

    /**
     * CONTROL2
     * [6]  WDTMR      : 0b1 (I2C Watchdog Timer: Enabled)
     * [5]  nSHDNPD_nEN: 0b0 (Active-Low Enable for nSHDN Pull-down Resistance: Enabled)
     * [4]  TJINT_M    : 0b00 (Junction Temperature Interrupt Mask: Unmasked)
     * [3:2]CKADV      : 0b00 (Ehanced Transient Response Enable and Sensitivity Selection: 75 mV/us)
     */
    { 0x03, 0xc1, 0x7c },

    /**
     * CHIPID
     * [7:4]ID_OTP     : 0b00001
     * [3:1]ID_M       : 0b001
     * [0]  TJINT_S    : 0b0 (The junction temperature is below TJ_WRN)
     */
    { 0x04, 0x12, 0xff },

    /**
     * INTERRUPT
     * [0]  TJINT_I    : 0b0 (The junction temperature did not exceed TJ_WRN)
     */
    { 0x05, 0x00, 0x01 }
};

}} // namespace nnt::bpc
