﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/nn_Common.h>

#include "testBpc_ExpectedEntry.h"

namespace nnt { namespace bpc {

const std::vector<ExpectedEntry> Max77620RtcExpectedEntries =
{
    // ===== 割込み =====

    /**
     * RTCINT
     * [4]  RTC1S       : 0b1 (1s Timer Expired)
     * [3]  SMPL        : 0b0
     * [2]  RTCA2       : 0b0
     * [1]  RTCA1       : 0b0
     * [0]  RTC60S      : 0b1 (60s Timer Expired)
     *
     * SDEV 起動直後の場合、60 s 割込みが入っていないので RTC60S はチェックしない。
     */
    { 0x00, 0x11, 0x1e },
    { 0x01, 0x3f, 0x1f }, // RTCINTM, Reset Value と等しい。

    // ===== コンフィグ =====

    /**
     * RTCCNTLM
     * [1] HRMODEM      : 0b1 (Writes to HRMODE allowed)
     * [0] BCDM         : 0b0 (Writes to BCD not allowed)
     *
     * 初期化完了後は動作モードの変更はできないことが望ましい。
     */
    { 0x02, 0x00, 0x03 },

    /**
     * RTCCNTL
     * [1] HRMODE       : 0b1 (24-Hour Mode)
     * [0] BCD          : 0b0 (Binary)
     *
     * HRMODE は 24H モードが必須。
     * BCD はバイナリモードが必須。
     */
    { 0x03, 0x02, 0x03 },

    /**
     * RTCUPDATE0
     * [4] RBUDR        : 0b0 (Read Buffder Update Register)
     * [2] FREEZE_SEC   : 0b0
     * [1] FCUR         : 0b0 (Flags Cleared Upon Read Control Bit)
     * [0] UDR          : 0b0 (Update Register)
     *
     * FCUR=0 なので後述する UDF, RBUDF は自動クリアされない。
     */
    { 0x04, 0x08, 0x17 },

    /**
     * RTCUPDATE1
     * [1] RBUDF        : 0b1 (Update Done)
     * [0] UDF          : 0b1 (Update Done)
     */
    { 0x05, 0x03, 0x03 },

    /**
     * RTCSMPL
     * [3:2]SMPLT       : 0b00 (0.5 s)
     * [7]  SMPL_EN     : 0b0 (Disabled)
     */
    { 0x06, 0x00, 0x8c },

    // ===== データ =====
    // 0x07 ~ 0x0d

    // ===== アラーム =====

    //{ 0x0e, 0x00, 0xff }, // RTCSECA1
    //{ 0x0f, 0x00, 0xff }, // RTCMINA1
    //{ 0x10, 0x00, 0xff }, // RTCHOURA1
    //{ 0x11, 0x01, 0xff }, // RTCDOWA1
    //{ 0x12, 0x01, 0xff }, // RTCMONTHA1
    //{ 0x13, 0x00, 0xff }, // RTCYEARA1
    //{ 0x14, 0x01, 0xff }, // RTCDOMA1
    //{ 0x15, 0x00, 0xff }, // RTCSECA2
    //{ 0x16, 0x00, 0xff }, // RTCMINA2
    //{ 0x17, 0x00, 0xff }, // RTCHOURA2
    //{ 0x18, 0x01, 0xff }, // RTCDOWA2
    //{ 0x19, 0x01, 0xff }, // RTCMONTHA2
    //{ 0x1a, 0x00, 0xff }, // RTCYEARA2
    //{ 0x1b, 0x01, 0xff }, // RTCDOMA2
};

}} // namespace nnt::bpc
