﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>

#include "BluetoothTools_Utility.h"

const char* toHexString(uint16_t length, const uint8_t buffer[])
{
    static char       hexString[128];                // for output
    static const char hex[] = "0123456789ABCDEF";    // for conversion

    int i = 0;

    if (!length)
    {
        memset(hexString, 0x00, sizeof(hexString));
        i = 3;
    }
    else
    {
        while (length && i < sizeof(hexString) - 3)
        {
            hexString[i++] = hex[(*buffer) >> 4];
            hexString[i++] = hex[(*buffer++) & 0xF];
            hexString[i++] = ':';
            length--;
        }
    }

    hexString[i - 1] = 0;  // null-terminate and remove the trailing ":"

    return hexString;
}

const char* toHexString(const nn::bluetooth::GattAttributeUuid &uuid)
{
    if (uuid.length == nn::bluetooth::GattAttributeUuidLength_16)
    {
        uint8_t uuidArray[2];
        uuidArray[0] = uuid.uu.uuid16;
        uuidArray[1] = (uuid.uu.uuid16 >> 8);
        return toHexString(nn::bluetooth::GattAttributeUuidLength_16, uuidArray);
    }
    else if (uuid.length == nn::bluetooth::GattAttributeUuidLength_32)
    {
        uint8_t uuidArray[4];
        uuidArray[0] = uuid.uu.uuid32;
        uuidArray[1] = (uuid.uu.uuid32 >> 8);
        uuidArray[2] = (uuid.uu.uuid32 >> 16);
        uuidArray[3] = (uuid.uu.uuid32 >> 24);
        return toHexString(nn::bluetooth::GattAttributeUuidLength_32, uuidArray);
    }
    else
    {
        return toHexString(nn::bluetooth::GattAttributeUuidLength_128, uuid.uu.uuid128);
    }
}

