﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bluetooth.h>

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_ReadServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x10, 0x01 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_ReadCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x11, 0x11 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_WriteServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x10, 0x02 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_WriteCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12, 0x12 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_WriteWithoutResponseServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x10, 0x03 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_WriteWithoutResponseCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x13, 0x13 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_NotificationServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x10, 0x04 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_NotificationCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x14, 0x14 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_IndicationServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x10, 0x05 }
};

const nn::bluetooth::GattAttributeUuid BleInteroperabilityTest_IndicationCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x1F, 0x1E, 0x1D, 0x1C, 0x1B, 0x1A, 0x19, 0x18, 0x17, 0x16, 0x15, 0x14, 0x13, 0x15, 0x15 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_SmallServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x00, 0x00, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_SmallReadCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x01, 0x01, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_SmallWriteCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x02, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_SmallWriteWithoutResponseCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x03, 0x03, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_SmallNotificationCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x04, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x00 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_LargeServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x10, 0x10, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_LargeReadCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x11, 0x11, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_LargeWriteCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x12, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_LargeWriteWithoutResponseCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x13, 0x13, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_LargeNotificationCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x14, 0x14, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x10 }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_DeviceConfigurationServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_AdvertisePacketConfigCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x01, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_ConnectionParameterConfigCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x02, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
};

const nn::bluetooth::GattAttributeUuid BleTestPeripheral_GattParameterConfigCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_ServiceUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x6C, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_CommandCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x6D, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_AddressWriterCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x6E, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_AddressReaderCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x6F, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_AdvertiseDataReaderCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x70, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid NintendoGattPairing_ErrorHandlerCharacteristicUuid =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0x71, 0x1C, 0xE0, 0xB4, 0x5D, 0x73, 0x6A, 0x8A, 0x1A, 0x4C, 0xA5, 0x4A, 0x26, 0x3E, 0xDC, 0xAD }
};

const nn::bluetooth::GattAttributeUuid ADV_SERVICE_UUID =
{
    .length = nn::bluetooth::GattAttributeUuidLength_128,
    .uu.uuid128 = { 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99 }
};
