﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os.h>
#include <nn/gfx/util/gfx_DebugFontTextWriter.h>
#include <nns/hid.h>

struct CursorPos
{
    uint16_t posX;
    uint16_t posY;
};

class SceneBase
{
public:
    explicit SceneBase(std::string title) { m_Title = title; }
    virtual ~SceneBase() {};

    virtual void Draw(nn::gfx::util::DebugFontTextWriter* pTextWriter) = 0;

    virtual void ProcessControllerInput(nns::hid::ButtonSet buttons) = 0;

    virtual std::string GetTitle() { return m_Title; }
protected:
    std::string m_Title;

    CursorPos m_Cursor;
};  // class Scene
