﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/bluetooth_Client.h"
#include <nn/bluetooth/bluetooth_Result.public.h>
#include <nn/bluetooth/bluetooth_Result.private.h>

#include <cstring>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>

class adapterPropertiesTestClient : public bluetoothClient
{
    public:
    nn::bluetooth::AdapterProperty gTestProperties;
    int nameLength = 0;

    adapterPropertiesTestClient()
    {
        gTestProperties.bluetoothAddress = {{0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc}};
        gTestProperties.bluetoothName    = {"I am a test"};
        gTestProperties.classOfDevice    = {{0xff, 0xee, 0xdd}};
        gTestProperties.featureSet       = 0x55;

        while(gTestProperties.bluetoothName.name[nameLength])
        {
            nameLength++;
        }
    }

    private:
};


static adapterPropertiesTestClient client;
/*******************************************************************************
* nnMain()
*******************************************************************************/
extern "C" void nnMain()
{
    NN_LOG("\n adapterPropertiesTestClient NOW RUNNING \n");

    nn::bluetooth::AdapterProperty receivedProperties;

    client.startBluetooth();
    nn::bluetooth::ExtSetVisibility(false,true);

    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(2000));

    for(int k=0; k<5; k++)
    {
        nn::Result result;
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Iteration %d\n", k);

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Testing get/set bluetooth address adapter property\n");
        NN_LOG("Set adapter address: %s\n", bluetoothClient::toHexString(sizeof(nn::bluetooth::BluetoothAddress), client.gTestProperties.bluetoothAddress.address));
        nn::bluetooth::SetAdapterProperty(nn::bluetooth::BT_PROPERTY_BDADDR, client.gTestProperties.bluetoothAddress.address, sizeof(nn::bluetooth::BluetoothAddress));
        nn::bluetooth::GetAdapterProperty(nn::bluetooth::BT_PROPERTY_BDADDR, receivedProperties.bluetoothAddress.address, sizeof(nn::bluetooth::BluetoothAddress));
        NN_LOG("Got adapter address: %s\n", bluetoothClient::toHexString(sizeof(nn::bluetooth::BluetoothAddress), receivedProperties.bluetoothAddress.address));

        if (memcmp(receivedProperties.bluetoothAddress.address, client.gTestProperties.bluetoothAddress.address, sizeof(nn::bluetooth::BluetoothAddress)))
        {
            NN_LOG("\t\t[FAIL] Adapter address received does not match the address that was set\n");

        }
        else
        {
            NN_LOG("\t\t[PASS] Adapter address received matches the address that was set\n");
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Testing get/set bluetooth name adapter property\n");
        NN_LOG("Set adapter name: %s\n", client.gTestProperties.bluetoothName.name);
        nn::bluetooth::SetAdapterProperty(nn::bluetooth::BT_PROPERTY_BDNAME, client.gTestProperties.bluetoothName.name, client.nameLength);
        nn::bluetooth::GetAdapterProperty(nn::bluetooth::BT_PROPERTY_BDNAME, receivedProperties.bluetoothName.name, sizeof(nn::bluetooth::BluetoothName));
        NN_LOG("Got adapter name: %s\n", receivedProperties.bluetoothName.name);

        if (memcmp(receivedProperties.bluetoothName.name, client.gTestProperties.bluetoothName.name, client.nameLength))
        {
            NN_LOG("\t\t[FAIL] Adapter name received does not match the name that was set\n");
        }
        else
        {
            NN_LOG("\t\t[PASS] Adapter name received matches the name that was set\n");
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Testing get/set class of device adapter property\n");
        NN_LOG("Set adapter class: %s\n", bluetoothClient::toHexString(sizeof(nn::bluetooth::ClassOfDevice), client.gTestProperties.classOfDevice.cod));
        nn::bluetooth::SetAdapterProperty(nn::bluetooth::BT_PROPERTY_CLASS_OF_DEVICE, client.gTestProperties.classOfDevice.cod, sizeof(nn::bluetooth::ClassOfDevice));
        nn::bluetooth::GetAdapterProperty(nn::bluetooth::BT_PROPERTY_CLASS_OF_DEVICE, receivedProperties.classOfDevice.cod, sizeof(nn::bluetooth::ClassOfDevice));
        NN_LOG("Got adapter class: %s\n", bluetoothClient::toHexString(sizeof(nn::bluetooth::ClassOfDevice), receivedProperties.classOfDevice.cod));

        if (memcmp(receivedProperties.classOfDevice.cod, client.gTestProperties.classOfDevice.cod, sizeof(nn::bluetooth::ClassOfDevice)))
        {
            NN_LOG("\t\t[FAIL] Adapter class received does not match the class that was set\n");
        }
        else
        {
            NN_LOG("\t\t[PASS] Adapter class received matches the class that was set\n");
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
        NN_LOG("\n-----------------------------------------------------------------------\n");
        NN_LOG("Testing get/set feature set adapter property\n");
        NN_LOG("Set adapter feature set: %x\n", client.gTestProperties.featureSet);
        nn::bluetooth::SetAdapterProperty(nn::bluetooth::BT_PROPERTY_FEATURE_SET, &client.gTestProperties.featureSet, sizeof(uint8_t));
        nn::bluetooth::GetAdapterProperty(nn::bluetooth::BT_PROPERTY_FEATURE_SET, &receivedProperties.featureSet, sizeof(uint8_t));
        NN_LOG("Got adapter feature set: %x\n", receivedProperties.featureSet);

        if (client.gTestProperties.featureSet == receivedProperties.featureSet)
        {
            NN_LOG("\t\t[PASS] Adapter feature set received matches the feature set that was set\n");
        }
        else
        {
            NN_LOG("\t\t[FAIL] Adapter feature set received does not match the feature set that was set\n");
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(2000));
    }

    client.finishBluetooth();

    SUCCEED();
}
