﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>

#include <nn/bluetooth/bluetooth_Types.h>

#include <nnt/nnt_Argument.h>

namespace nnt { namespace bluetooth {
namespace {
    const nn::bluetooth::BluetoothAddress TARGET_DEVICES[] = {
        {{ 0x40, 0xD2, 0x8A, 0xB4, 0xD5, 0xEC }},
        //{{ 0x40, 0xD2, 0x8A, 0xB4, 0xC6, 0x69 }},
    };
    const char* TARGET_DEVICE_NAME[] = {
        "NintendoGamepad",
        "Joy-Con",
    };
    bool g_IsAddressFilter = false;
}

inline bool IsTargetBdaddr(const nn::bluetooth::BluetoothAddress* pAddr)
{
    for (auto testAddr : TARGET_DEVICES)
    {
        if (std::memcmp(pAddr->address, testAddr.address, 6) == 0)
        {
            return true;
        }
    }
    return false;
}

inline bool IsNintendoGamepad(const nn::bluetooth::BluetoothName* pName)
{
    for (auto testName : TARGET_DEVICE_NAME)
    {
        if (std::memcmp(pName->name, testName, std::strlen(testName)) == 0)
        {
            return true;
        }
    }
    return false;
}

inline bool IsTardetDevice(const nn::bluetooth::BluetoothName* pName, const nn::bluetooth::BluetoothAddress* pAddr)
{
    return g_IsAddressFilter ? IsNintendoGamepad(pName) & IsTargetBdaddr(pAddr) : IsNintendoGamepad(pName);
}

inline void CheckFilterOption()
{
    for (int i = 0; i < nnt::GetHostArgc(); i++)
    {
        if (nnt::GetHostArgv()[i] != nullptr)
        {
            if (std::strcmp(nnt::GetHostArgv()[i], "--bd_filter") == 0)
            {
                NN_LOG("Enabled Bdaddress filter.\n");
                g_IsAddressFilter = true;
            }
        }
    }
}

}}
